#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "interface.h"
#include "support.h"

extern GtkWidget *window, *notebook;
extern GtkWidget *nick_availability_entry;
extern GtkWidget *page1_connect_button;
extern GtkWidget *page4_connect_button;
extern GtkWidget *register_password_confirm_entry;
extern GtkWidget *register_username_entry;
extern GtkWidget *username_entry, *register_username_entry;

const gchar *userdefined_nickname;

int
main (int argc, char *argv[])
{

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");

  if (argv[1] == 0)
	{
	g_print("This program cannot be run by itself\n");
	g_print("Please run 'ubuntu-live-support' instead\n");
	gtk_main_quit();
	return 1;
	} 

  if (argv[2] == 0)
	{
	g_print("This program cannot be run by itself\n");
	g_print("Please run 'ubuntu-live-support' instead\n");
	gtk_main_quit();
	return 1;
	} 

  if (argv[3] == 0)
	{
	g_print("This program cannot be run by itself\n");
	g_print("Please run 'ubuntu-live-support' instead\n");
	gtk_main_quit();
	return 1;
	} 

  else

	{
  	window = create_window ();
  	gtk_widget_show (window);
	gtk_widget_set_sensitive (GTK_WIDGET (page1_connect_button), FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (page4_connect_button), FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (register_username_entry), FALSE);
  	gtk_entry_set_text(GTK_ENTRY (username_entry), argv[1]);
	gtk_entry_set_text(GTK_ENTRY (nick_availability_entry), argv[2]);
	if (!strcmp(argv[3],"register")) {
	gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), 4);
	}
	if (!strcmp(argv[3],"login")) {
	gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), 1);
	}
	if (!strcmp(argv[3],"main")) {
	gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), 0);
	}
	if (!strcmp(argv[3],"check")) {
	gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), 3);
	}
	userdefined_nickname = gtk_entry_get_text(GTK_ENTRY (nick_availability_entry));
  	gtk_entry_set_text(GTK_ENTRY (register_username_entry), userdefined_nickname);

  	gtk_main ();

  	return 0;
	}

}

