#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)

  GtkWidget *window;
  GtkWidget *notebook;

  GtkWidget *check_availability_button;
  GtkWidget *nick_availability_entry;
  GtkWidget *page0_about_button;
  GtkWidget *page0_cancel_button;
  GtkWidget *page0_next_button;
  GtkWidget *page1_back_button;
  GtkWidget *page1_connect_button;
  GtkWidget *page1_register_button;
  GtkWidget *page1_settings_alternative_radiobutton;
  GtkWidget *page1_settings_default_radiobutton;
  GtkWidget *page1_settings_togglebutton;
  GtkWidget *page2_back_button;
  GtkWidget *page2_next_button;
  GtkWidget *page3_back_button;
  GtkWidget *page3_next_button;
  GtkWidget *page4_back_button;
  GtkWidget *page4_connect_button;
  GtkWidget *page4_share_checkbutton;
  GtkWidget *page5_credits_button;
  GtkWidget *page5_license_button;
  GtkWidget *page5_ok_button;
  GtkWidget *page6_back_button;
  GtkWidget *password_entry;
  GtkWidget *passwords_warning_label;
  GtkWidget *register_email_entry;
  GtkWidget *register_gsm_entry;
  GtkWidget *register_password_confirm_entry;
  GtkWidget *register_password_entry;
  GtkWidget *register_phone_entry;
  GtkWidget *register_username_entry;
  GtkWidget *register_website_entry;
  GtkWidget *settings_notebook;
  GtkWidget *unregistered_login_checkbox;
  GtkWidget *unregistered_login_label_message;
  GtkWidget *username_entry;

GtkWidget*
create_window (void)
{

  GtkWidget *page0_next_button_image;
  GtkWidget *account_label;
  GtkWidget *account_page_fixed;
  GtkWidget *account_page_fixed2;
  GtkWidget *account_page_logo;
  GtkWidget *account_page_tab_label;
  GtkWidget *account_password_label;
  GtkWidget *account_username_label;
  GtkWidget *alignment3;
  GtkWidget *alignment4;
  GtkWidget *alignment5;
  GtkWidget *alignment6;
  GtkWidget *empty_label;
  GtkWidget *empty_notebook_page;
  GtkWidget *hbox1;
  GtkWidget *hbox11;
  GtkWidget *hbox12;
  GtkWidget *hbox15;
  GtkWidget *hbox16;
  GtkWidget *hbox17;
  GtkWidget *hbox18;
  GtkWidget *hbox19;
  GtkWidget *hbox2;
  GtkWidget *hbox20;
  GtkWidget *hbox21;
  GtkWidget *hbox22;
  GtkWidget *hbox23;
  GtkWidget *hbox24;
  GtkWidget *hbox25;
  GtkWidget *hbox26;
  GtkWidget *hbox27;
  GtkWidget *hbox28;
  GtkWidget *hbox29;
  GtkWidget *hbox3;
  GtkWidget *hbox30;
  GtkWidget *hbox31;
  GtkWidget *hbox32;
  GtkWidget *hbox33;
  GtkWidget *hbox34;
  GtkWidget *hbox5;
  GtkWidget *hbox6;
  GtkWidget *hbox8;
  GtkWidget *hbox9;
  GtkWidget *hbuttonbox1;
  GtkWidget *hbuttonbox10;
  GtkWidget *hbuttonbox11;
  GtkWidget *hbuttonbox12;
  GtkWidget *hbuttonbox14;
  GtkWidget *hbuttonbox15;
  GtkWidget *hbuttonbox6;
  GtkWidget *hbuttonbox7;
  GtkWidget *hbuttonbox8;
  GtkWidget *hbuttonbox9;
  GtkWidget *hseparator1;
  GtkWidget *hseparator2;
  GtkWidget *hseparator3;
  GtkWidget *image10;
  GtkWidget *image11;
  GtkWidget *image12;
  GtkWidget *image13;
  GtkWidget *image14;
  GtkWidget *image5;
  GtkWidget *image7;
  GtkWidget *image8;
  GtkWidget *image9;
  GtkWidget *intro_label;
  GtkWidget *intro_page_logo;
  GtkWidget *intro_page_tab_label;
  GtkWidget *intro_text;
  GtkWidget *label12;
  GtkWidget *label20;
  GtkWidget *label21;
  GtkWidget *label22;
  GtkWidget *label25;
  GtkWidget *label27;
  GtkWidget *label3;
  GtkWidget *label31;
  GtkWidget *label32;
  GtkWidget *label33;
  GtkWidget *label34;
  GtkWidget *label35;
  GtkWidget *label36;
  GtkWidget *label37;
  GtkWidget *label38;
  GtkWidget *label39;
  GtkWidget *label40;
  GtkWidget *label41;
  GtkWidget *label42;
  GtkWidget *label44;
  GtkWidget *label45;
  GtkWidget *label46;
  GtkWidget *label47;
  GtkWidget *label48;
  GtkWidget *label49;
  GtkWidget *label50;
  GtkWidget *label51;
  GtkWidget *label52;
  GtkWidget *label53;
  GtkWidget *label54;
  GtkWidget *label55;
  GtkWidget *label56;
  GtkWidget *label57;
  GtkWidget *label58;
  GtkWidget *label59;
  GtkWidget *label7;
  GtkWidget *license_textview;
  GtkWidget *page0_next_button_alignment;
  GtkWidget *page0_next_button_label;
  GtkWidget *page1_connect_button_alignment;
  GtkWidget *page1_connect_button_image;
  GtkWidget *page1_connect_button_label;
  GtkWidget *page1_register_button_alignment;
  GtkWidget *page1_register_button_hbox;
  GtkWidget *page1_register_button_image;
  GtkWidget *page1_register_button_label;
  GtkWidget *page1_settings_button_hbox;
  GtkWidget *page1_settings_button_image;
  GtkWidget *page1_settings_button_label;
  GtkWidget *page4_send_button_alignment;
  GtkWidget *page4_send_button_image;
  GtkWidget *page4_send_button_label;
  GtkWidget *scrolledwindow1;
  GtkWidget *scrolledwindow2;
  GtkWidget *settings_alternative_layout_image;
  GtkWidget *settings_button_alignment;
  GtkWidget *settings_default_layout_image;
  GtkWidget *settings_page_label;
  GtkWidget *textview1;
  GtkWidget *vbox1;
  GtkWidget *vbox10;
  GtkWidget *vbox11;
  GtkWidget *vbox2;
  GtkWidget *vbox3;
  GtkWidget *vbox4;
  GtkWidget *vbox5;
  GtkWidget *vbox6;
  GtkWidget *vbox7;
  GtkWidget *vbox8;
  GtkWidget *vbox9;

  GSList *page1_settings_default_radiobutton_group = NULL;
  GtkTooltips *tooltips;

  tooltips = gtk_tooltips_new ();

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_size_request (window, -1, 555);
  gtk_window_set_title (GTK_WINDOW (window), _("Ubuntu Live Chat Support"));
  gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER_ALWAYS);
  gtk_window_set_resizable (GTK_WINDOW (window), FALSE);
  gtk_window_set_icon_name (GTK_WINDOW (window), "stock_people");

  notebook = gtk_notebook_new ();
  gtk_widget_show (notebook);
  gtk_container_add (GTK_CONTAINER (window), notebook);
  gtk_container_set_border_width (GTK_CONTAINER (notebook), 5);
  GTK_WIDGET_UNSET_FLAGS (notebook, GTK_CAN_FOCUS);
  gtk_notebook_set_show_tabs (GTK_NOTEBOOK (notebook), FALSE);
  gtk_notebook_set_show_border (GTK_NOTEBOOK (notebook), FALSE);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (notebook), vbox1);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, TRUE, 5);

  intro_page_logo = gtk_image_new_from_icon_name ("stock_people", GTK_ICON_SIZE_DIALOG);
  gtk_widget_show (intro_page_logo);
  gtk_box_pack_start (GTK_BOX (hbox1), intro_page_logo, FALSE, TRUE, 0);
  gtk_misc_set_padding (GTK_MISC (intro_page_logo), 30, 0);

  intro_label = gtk_label_new (_("<span size=\"x-large\">Ubuntu Live Chat Support</span>"));
  gtk_widget_show (intro_label);
  gtk_box_pack_start (GTK_BOX (hbox1), intro_label, FALSE, FALSE, 0);
  gtk_label_set_use_markup (GTK_LABEL (intro_label), TRUE);

  intro_text = gtk_label_new (_("Welcome to Ubuntu Live Chat Support.\n\nThis will connect you to the Official Ubuntu Support Channel and your Local \nUbuntu Support Channel, where you can chat with hundreds of Ubuntu users. \n\nYou will be asked to supply your registered Freenode.net account. However,\nif you don't have an account yet, you can click the \"Register\" button in the next\nscreen to learn the benefits of registering your nick.\n\nTo continue, please click the \"Next\" button."));
  gtk_widget_show (intro_text);
  gtk_box_pack_start (GTK_BOX (vbox1), intro_text, FALSE, TRUE, 10);
  gtk_label_set_use_markup (GTK_LABEL (intro_text), TRUE);
  gtk_misc_set_padding (GTK_MISC (intro_text), 10, 0);

  hbox17 = gtk_hbox_new (TRUE, 0);
  gtk_widget_show (hbox17);
  gtk_box_pack_end (GTK_BOX (vbox1), hbox17, FALSE, FALSE, 0);

  hbuttonbox10 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox10);
  gtk_box_pack_start (GTK_BOX (hbox17), hbuttonbox10, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbuttonbox10), 10);
  gtk_box_set_spacing (GTK_BOX (hbuttonbox10), 15);

  page0_about_button = gtk_button_new_from_stock ("gtk-about");
  gtk_widget_show (page0_about_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox10), page0_about_button);
  gtk_widget_set_size_request (page0_about_button, 87, 36);
  GTK_WIDGET_SET_FLAGS (page0_about_button, GTK_CAN_DEFAULT);

  hbuttonbox1 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox1);
  gtk_box_pack_start (GTK_BOX (hbox17), hbuttonbox1, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbuttonbox1), 10);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox1), GTK_BUTTONBOX_END);
  gtk_box_set_spacing (GTK_BOX (hbuttonbox1), 15);

  page0_cancel_button = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (page0_cancel_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), page0_cancel_button);
  gtk_widget_set_size_request (page0_cancel_button, 87, 36);
  GTK_WIDGET_SET_FLAGS (page0_cancel_button, GTK_CAN_DEFAULT);

  page0_next_button = gtk_button_new ();
  gtk_widget_show (page0_next_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), page0_next_button);
  gtk_widget_set_size_request (page0_next_button, 87, 36);
  GTK_WIDGET_SET_FLAGS (page0_next_button, GTK_CAN_DEFAULT);

  page0_next_button_alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (page0_next_button_alignment);
  gtk_container_add (GTK_CONTAINER (page0_next_button), page0_next_button_alignment);

  hbox2 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox2);
  gtk_container_add (GTK_CONTAINER (page0_next_button_alignment), hbox2);

  page0_next_button_image = gtk_image_new_from_stock ("gtk-go-forward", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (page0_next_button_image);
  gtk_box_pack_start (GTK_BOX (hbox2), page0_next_button_image, FALSE, FALSE, 0);

  page0_next_button_label = gtk_label_new_with_mnemonic (_("_Next"));
  gtk_widget_show (page0_next_button_label);
  gtk_box_pack_start (GTK_BOX (hbox2), page0_next_button_label, FALSE, FALSE, 0);

  intro_page_tab_label = gtk_label_new (_("intro"));
  gtk_widget_show (intro_page_tab_label);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 0), intro_page_tab_label);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (notebook), vbox2);

  hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox3, FALSE, FALSE, 5);

  account_page_logo = gtk_image_new_from_icon_name ("gtk-dialog-info", GTK_ICON_SIZE_DIALOG);
  gtk_widget_show (account_page_logo);
  gtk_box_pack_start (GTK_BOX (hbox3), account_page_logo, FALSE, TRUE, 0);
  gtk_misc_set_padding (GTK_MISC (account_page_logo), 30, 0);

  label7 = gtk_label_new (_("<span size=\"x-large\">Account Information</span>"));
  gtk_widget_show (label7);
  gtk_box_pack_start (GTK_BOX (hbox3), label7, FALSE, FALSE, 0);
  gtk_label_set_use_markup (GTK_LABEL (label7), TRUE);

  account_label = gtk_label_new (_("Please provide your registered Freenode.net username and password to \ncontinue.\n\nIf you don't have an account, click the \"Use unregistered login\" checkbox, \nor register to freenode using the the \"Register\" button."));
  gtk_widget_show (account_label);
  gtk_box_pack_start (GTK_BOX (vbox2), account_label, FALSE, TRUE, 10);

  account_page_fixed = gtk_fixed_new ();
  gtk_widget_show (account_page_fixed);
  gtk_box_pack_start (GTK_BOX (vbox2), account_page_fixed, FALSE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (account_page_fixed), 10);

  username_entry = gtk_entry_new ();
  gtk_widget_show (username_entry);
  gtk_fixed_put (GTK_FIXED (account_page_fixed), username_entry, 200, 0);
  gtk_widget_set_size_request (username_entry, 160, 27);
  gtk_entry_set_max_length (GTK_ENTRY (username_entry), 16);

  password_entry = gtk_entry_new ();
  gtk_widget_show (password_entry);
  gtk_fixed_put (GTK_FIXED (account_page_fixed), password_entry, 200, 32);
  gtk_widget_set_size_request (password_entry, 160, 27);
  gtk_entry_set_visibility (GTK_ENTRY (password_entry), FALSE);
  gtk_entry_set_invisible_char (GTK_ENTRY (password_entry), 9679);

  account_password_label = gtk_label_new (_("Password:"));
  gtk_widget_show (account_password_label);
  gtk_fixed_put (GTK_FIXED (account_page_fixed), account_password_label, 96, 40);
  gtk_widget_set_size_request (account_password_label, 104, 16);

  account_username_label = gtk_label_new (_("Username:"));
  gtk_widget_show (account_username_label);
  gtk_fixed_put (GTK_FIXED (account_page_fixed), account_username_label, 96, 8);
  gtk_widget_set_size_request (account_username_label, 104, 16);

  hbox6 = gtk_hbox_new (TRUE, 0);
  gtk_widget_show (hbox6);
  gtk_box_pack_end (GTK_BOX (vbox2), hbox6, FALSE, FALSE, 0);

  hbuttonbox7 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox7);
  gtk_box_pack_start (GTK_BOX (hbox6), hbuttonbox7, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbuttonbox7), 10);

  page1_register_button = gtk_button_new ();
  gtk_widget_show (page1_register_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox7), page1_register_button);
  gtk_widget_set_size_request (page1_register_button, 87, 36);
  GTK_WIDGET_SET_FLAGS (page1_register_button, GTK_CAN_DEFAULT);

  page1_register_button_alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (page1_register_button_alignment);
  gtk_container_add (GTK_CONTAINER (page1_register_button), page1_register_button_alignment);

  page1_register_button_hbox = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (page1_register_button_hbox);
  gtk_container_add (GTK_CONTAINER (page1_register_button_alignment), page1_register_button_hbox);

  page1_register_button_image = gtk_image_new_from_icon_name ("stock_contact", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (page1_register_button_image);
  gtk_box_pack_start (GTK_BOX (page1_register_button_hbox), page1_register_button_image, FALSE, FALSE, 0);

  page1_register_button_label = gtk_label_new_with_mnemonic (_("_Register"));
  gtk_widget_show (page1_register_button_label);
  gtk_box_pack_start (GTK_BOX (page1_register_button_hbox), page1_register_button_label, FALSE, FALSE, 0);

  hbuttonbox6 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox6);
  gtk_box_pack_start (GTK_BOX (hbox6), hbuttonbox6, FALSE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbuttonbox6), 10);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox6), GTK_BUTTONBOX_END);
  gtk_box_set_spacing (GTK_BOX (hbuttonbox6), 15);

  page1_back_button = gtk_button_new_from_stock ("gtk-go-back");
  gtk_widget_show (page1_back_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox6), page1_back_button);
  gtk_widget_set_size_request (page1_back_button, 87, 36);
  GTK_WIDGET_SET_FLAGS (page1_back_button, GTK_CAN_DEFAULT);

  page1_connect_button = gtk_button_new ();
  gtk_widget_show (page1_connect_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox6), page1_connect_button);
  gtk_widget_set_size_request (page1_connect_button, 87, 36);
  GTK_WIDGET_SET_FLAGS (page1_connect_button, GTK_CAN_DEFAULT);

  page1_connect_button_alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (page1_connect_button_alignment);
  gtk_container_add (GTK_CONTAINER (page1_connect_button), page1_connect_button_alignment);

  hbox32 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox32);
  gtk_container_add (GTK_CONTAINER (page1_connect_button_alignment), hbox32);

  page1_connect_button_image = gtk_image_new_from_stock ("gtk-connect", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (page1_connect_button_image);
  gtk_box_pack_start (GTK_BOX (hbox32), page1_connect_button_image, FALSE, FALSE, 0);

  page1_connect_button_label = gtk_label_new_with_mnemonic ("_Connect");
  gtk_widget_show (page1_connect_button_label);
  gtk_box_pack_start (GTK_BOX (hbox32), page1_connect_button_label, FALSE, FALSE, 0);

  account_page_fixed2 = gtk_fixed_new ();
  gtk_widget_show (account_page_fixed2);
  gtk_box_pack_start (GTK_BOX (vbox2), account_page_fixed2, FALSE, FALSE, 0);

  settings_notebook = gtk_notebook_new ();
  gtk_widget_show (settings_notebook);
  gtk_fixed_put (GTK_FIXED (account_page_fixed2), settings_notebook, 112, 64);
  gtk_widget_set_size_request (settings_notebook, 312, 160);
  GTK_WIDGET_UNSET_FLAGS (settings_notebook, GTK_CAN_FOCUS);
  gtk_notebook_set_show_tabs (GTK_NOTEBOOK (settings_notebook), FALSE);
  gtk_notebook_set_show_border (GTK_NOTEBOOK (settings_notebook), FALSE);

  empty_notebook_page = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (empty_notebook_page);
  gtk_container_add (GTK_CONTAINER (settings_notebook), empty_notebook_page);

  empty_label = gtk_label_new (_("empty"));
  gtk_widget_show (empty_label);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (settings_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (settings_notebook), 0), empty_label);

  hbox33 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox33);
  gtk_container_add (GTK_CONTAINER (settings_notebook), hbox33);

  vbox10 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox10);
  gtk_box_pack_start (GTK_BOX (hbox33), vbox10, TRUE, TRUE, 0);

  page1_settings_default_radiobutton = gtk_radio_button_new_with_mnemonic (NULL, _("_Default Layout"));
  gtk_widget_show (page1_settings_default_radiobutton);
  gtk_box_pack_start (GTK_BOX (vbox10), page1_settings_default_radiobutton, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (page1_settings_default_radiobutton), page1_settings_default_radiobutton_group);
  page1_settings_default_radiobutton_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (page1_settings_default_radiobutton));

  settings_default_layout_image = create_pixmap (window, "default.xpm");
  gtk_widget_show (settings_default_layout_image);
  gtk_box_pack_start (GTK_BOX (vbox10), settings_default_layout_image, TRUE, TRUE, 0);
  gtk_misc_set_padding (GTK_MISC (settings_default_layout_image), 30, 0);

  vbox11 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox11);
  gtk_box_pack_start (GTK_BOX (hbox33), vbox11, TRUE, TRUE, 0);

  page1_settings_alternative_radiobutton = gtk_radio_button_new_with_mnemonic (NULL, _("_Alternative Layout"));
  gtk_widget_show (page1_settings_alternative_radiobutton);
  gtk_box_pack_start (GTK_BOX (vbox11), page1_settings_alternative_radiobutton, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (page1_settings_alternative_radiobutton), page1_settings_default_radiobutton_group);
  page1_settings_default_radiobutton_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (page1_settings_alternative_radiobutton));

  settings_alternative_layout_image = create_pixmap (window, "alternative.xpm");
  gtk_widget_show (settings_alternative_layout_image);
  gtk_box_pack_start (GTK_BOX (vbox11), settings_alternative_layout_image, TRUE, TRUE, 0);
  gtk_misc_set_padding (GTK_MISC (settings_alternative_layout_image), 30, 0);

  settings_page_label = gtk_label_new (_("settings"));
  gtk_widget_show (settings_page_label);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (settings_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (settings_notebook), 1), settings_page_label);

  unregistered_login_checkbox = gtk_check_button_new_with_mnemonic (_("Use unregistered login"));
  gtk_widget_show (unregistered_login_checkbox);
  gtk_fixed_put (GTK_FIXED (account_page_fixed2), unregistered_login_checkbox, 98, 8);
  gtk_widget_set_size_request (unregistered_login_checkbox, 184, 24);

  unregistered_login_label_message = gtk_label_new (_("By using an unregistered login, your nick will have a \"guest_\" prefix."));
  gtk_fixed_put (GTK_FIXED (account_page_fixed2), unregistered_login_label_message, 16, 40);
  gtk_widget_set_size_request (unregistered_login_label_message, 504, 16);

  page1_settings_togglebutton = gtk_toggle_button_new ();
  gtk_widget_show (page1_settings_togglebutton);
  gtk_fixed_put (GTK_FIXED (account_page_fixed2), page1_settings_togglebutton, 280, 0);
  gtk_widget_set_size_request (page1_settings_togglebutton, 110, 32);

  settings_button_alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (settings_button_alignment);
  gtk_container_add (GTK_CONTAINER (page1_settings_togglebutton), settings_button_alignment);

  page1_settings_button_hbox = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (page1_settings_button_hbox);
  gtk_container_add (GTK_CONTAINER (settings_button_alignment), page1_settings_button_hbox);

  page1_settings_button_image = gtk_image_new_from_stock ("gtk-properties", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (page1_settings_button_image);
  gtk_box_pack_start (GTK_BOX (page1_settings_button_hbox), page1_settings_button_image, FALSE, FALSE, 0);

  page1_settings_button_label = gtk_label_new_with_mnemonic (_("_Settings"));
  gtk_widget_show (page1_settings_button_label);
  gtk_box_pack_start (GTK_BOX (page1_settings_button_hbox), page1_settings_button_label, FALSE, FALSE, 0);

  account_page_tab_label = gtk_label_new (_("label2"));
  gtk_widget_show (account_page_tab_label);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 1), account_page_tab_label);

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox3);
  gtk_container_add (GTK_CONTAINER (notebook), vbox3);

  hbox5 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox5);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox5, FALSE, TRUE, 5);

  image5 = gtk_image_new_from_icon_name ("stock_contact", GTK_ICON_SIZE_DIALOG);
  gtk_widget_show (image5);
  gtk_box_pack_start (GTK_BOX (hbox5), image5, FALSE, TRUE, 0);
  gtk_misc_set_padding (GTK_MISC (image5), 30, 0);

  label12 = gtk_label_new (_("<span size=\"x-large\">Why Should I Register?</span>"));
  gtk_widget_show (label12);
  gtk_box_pack_start (GTK_BOX (hbox5), label12, FALSE, FALSE, 0);
  gtk_label_set_use_markup (GTK_LABEL (label12), TRUE);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (vbox3), scrolledwindow1, TRUE, TRUE, 10);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_SHADOW_IN);

  textview1 = gtk_text_view_new ();
  gtk_widget_show (textview1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), textview1);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (textview1), FALSE);
  gtk_text_view_set_accepts_tab (GTK_TEXT_VIEW (textview1), FALSE);
  gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (textview1), GTK_WRAP_WORD);
  gtk_text_buffer_set_text (gtk_text_view_get_buffer (GTK_TEXT_VIEW (textview1)), _("When you register your nick, people in freenode and alot of ubuntu users will\nknow you by your nick. Once you register it, you don't need to register it again,\nand you will be able to use your nick everytime you need support or when you\nconnect to freenode. But if you don't register it, someone might register the\nnick that you want. \n\nBy using your registered nick, people will know you on how you communicate\nwith them, they will have a more personal intimacy with you, because they\nknow you much better by your reputation.\n\nWhen you register your nick, you can send private messages to other ubuntu\nlinux users and to all people who register to freenode, this way, you can talk \nto someone personally about your technical problems.\n\nIf you register your nick, you will have a much greater security of being abused\nby attackers, because some channels have special modes in them that\nprotects registered users from abusive attacks. Some channels even have\nmodes in them that don't allow unregistered users to join or to send a\nmessage in a channel.\n\nA registered nick will provide you a greater security, alot of ways to know you\nmuch better, and the freedom to communicate to alot of people.\n\nFor more information, you can visit http://www.freenode.org\n"), -1);

  hbuttonbox8 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox8);
  gtk_box_pack_end (GTK_BOX (vbox3), hbuttonbox8, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbuttonbox8), 10);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox8), GTK_BUTTONBOX_END);
  gtk_box_set_spacing (GTK_BOX (hbuttonbox8), 15);

  page2_back_button = gtk_button_new_from_stock ("gtk-go-back");
  gtk_widget_show (page2_back_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox8), page2_back_button);
  gtk_widget_set_size_request (page2_back_button, 87, 36);
  GTK_WIDGET_SET_FLAGS (page2_back_button, GTK_CAN_DEFAULT);

  page2_next_button = gtk_button_new ();
  gtk_widget_show (page2_next_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox8), page2_next_button);
  gtk_widget_set_size_request (page2_next_button, 87, 36);
  GTK_WIDGET_SET_FLAGS (page2_next_button, GTK_CAN_DEFAULT);

  alignment3 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment3);
  gtk_container_add (GTK_CONTAINER (page2_next_button), alignment3);

  hbox8 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox8);
  gtk_container_add (GTK_CONTAINER (alignment3), hbox8);

  image7 = gtk_image_new_from_stock ("gtk-go-forward", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image7);
  gtk_box_pack_start (GTK_BOX (hbox8), image7, FALSE, FALSE, 0);

  label20 = gtk_label_new_with_mnemonic ("_Next");
  gtk_widget_show (label20);
  gtk_box_pack_start (GTK_BOX (hbox8), label20, FALSE, FALSE, 0);

  label35 = gtk_label_new (_("Click the \"Next\" Button to begin registration."));
  gtk_widget_show (label35);
  gtk_box_pack_start (GTK_BOX (vbox3), label35, FALSE, FALSE, 0);

  label3 = gtk_label_new (_("label3"));
  gtk_widget_show (label3);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 2), label3);

  vbox8 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox8);
  gtk_container_add (GTK_CONTAINER (notebook), vbox8);

  hbox27 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox27);
  gtk_box_pack_start (GTK_BOX (vbox8), hbox27, FALSE, TRUE, 5);

  image13 = gtk_image_new_from_icon_name ("stock_contact", GTK_ICON_SIZE_DIALOG);
  gtk_widget_show (image13);
  gtk_box_pack_start (GTK_BOX (hbox27), image13, FALSE, TRUE, 0);
  gtk_misc_set_padding (GTK_MISC (image13), 30, 0);

  label52 = gtk_label_new (_("<span size=\"x-large\">Nick Registration</span>"));
  gtk_widget_show (label52);
  gtk_box_pack_start (GTK_BOX (hbox27), label52, FALSE, FALSE, 0);
  gtk_label_set_use_markup (GTK_LABEL (label52), TRUE);

  hbox28 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox28);
  gtk_box_pack_start (GTK_BOX (vbox8), hbox28, TRUE, TRUE, 0);

  label53 = gtk_label_new (_("<span background=\"brown\" foreground=\"white\" size=\"xx-large\">     \n     \n     \n     \n     \n     \n 1  \n     \n     \n     \n     \n     </span>"));
  gtk_widget_show (label53);
  gtk_box_pack_start (GTK_BOX (hbox28), label53, FALSE, FALSE, 0);
  gtk_label_set_use_markup (GTK_LABEL (label53), TRUE);

  vbox9 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox9);
  gtk_box_pack_start (GTK_BOX (hbox28), vbox9, FALSE, TRUE, 0);

  label54 = gtk_label_new (_("Choose a unique name for your nick. Please avoid using name of a\ntrademarked entity or a community project, this way, you can avoid\nany conflicts with them."));
  gtk_widget_show (label54);
  gtk_box_pack_start (GTK_BOX (vbox9), label54, FALSE, FALSE, 10);
  gtk_label_set_use_markup (GTK_LABEL (label54), TRUE);
  gtk_misc_set_padding (GTK_MISC (label54), 10, 0);

  hbox29 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox29);
  gtk_box_pack_start (GTK_BOX (vbox9), hbox29, FALSE, FALSE, 10);
  gtk_container_set_border_width (GTK_CONTAINER (hbox29), 2);

  label55 = gtk_label_new (_("Username: "));
  gtk_widget_show (label55);
  gtk_box_pack_start (GTK_BOX (hbox29), label55, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label55, 230, -1);
  gtk_misc_set_padding (GTK_MISC (label55), 20, 0);

  nick_availability_entry = gtk_entry_new ();
  gtk_widget_show (nick_availability_entry);
  gtk_box_pack_start (GTK_BOX (hbox29), nick_availability_entry, FALSE, FALSE, 0);
  gtk_widget_set_size_request (nick_availability_entry, 230, -1);
  gtk_entry_set_max_length (GTK_ENTRY (nick_availability_entry), 16);

  check_availability_button = gtk_button_new_with_mnemonic (_("_Check Availability"));
  gtk_widget_show (check_availability_button);
  gtk_box_pack_start (GTK_BOX (vbox9), check_availability_button, FALSE, FALSE, 0);

  label56 = gtk_label_new (_("If your finish choosing your nick, click the \"Next\" button."));
  gtk_widget_show (label56);
  gtk_box_pack_end (GTK_BOX (vbox9), label56, FALSE, FALSE, 0);

  label59 = gtk_label_new (_("You can check the availability of your chosen nick, \nby clicking the \"Check Availability\" button."));
  gtk_widget_show (label59);
  gtk_box_pack_start (GTK_BOX (vbox9), label59, FALSE, FALSE, 0);

  hseparator3 = gtk_hseparator_new ();
  gtk_widget_show (hseparator3);
  gtk_box_pack_start (GTK_BOX (vbox8), hseparator3, FALSE, FALSE, 0);

  hbuttonbox15 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox15);
  gtk_box_pack_end (GTK_BOX (vbox8), hbuttonbox15, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbuttonbox15), 10);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox15), GTK_BUTTONBOX_END);
  gtk_box_set_spacing (GTK_BOX (hbuttonbox15), 15);

  page3_back_button = gtk_button_new_from_stock ("gtk-go-back");
  gtk_widget_show (page3_back_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox15), page3_back_button);
  gtk_widget_set_size_request (page3_back_button, 87, 36);
  GTK_WIDGET_SET_FLAGS (page3_back_button, GTK_CAN_DEFAULT);

  page3_next_button = gtk_button_new ();
  gtk_widget_show (page3_next_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox15), page3_next_button);
  gtk_widget_set_size_request (page3_next_button, 87, 36);
  GTK_WIDGET_SET_FLAGS (page3_next_button, GTK_CAN_DEFAULT);

  alignment6 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment6);
  gtk_container_add (GTK_CONTAINER (page3_next_button), alignment6);

  hbox30 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox30);
  gtk_container_add (GTK_CONTAINER (alignment6), hbox30);

  image14 = gtk_image_new_from_stock ("gtk-go-forward", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image14);
  gtk_box_pack_start (GTK_BOX (hbox30), image14, FALSE, FALSE, 0);

  label57 = gtk_label_new_with_mnemonic ("_Next");
  gtk_widget_show (label57);
  gtk_box_pack_start (GTK_BOX (hbox30), label57, FALSE, FALSE, 0);

  label51 = gtk_label_new (_("label51"));
  gtk_widget_show (label51);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 3), label51);

  vbox4 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox4);
  gtk_container_add (GTK_CONTAINER (notebook), vbox4);

  hbox9 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox9);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox9, FALSE, FALSE, 5);

  image8 = gtk_image_new_from_icon_name ("stock_contact", GTK_ICON_SIZE_DIALOG);
  gtk_widget_show (image8);
  gtk_box_pack_start (GTK_BOX (hbox9), image8, FALSE, TRUE, 0);
  gtk_misc_set_padding (GTK_MISC (image8), 30, 0);

  label22 = gtk_label_new (_("<span size=\"x-large\">Enter your registration details</span>"));
  gtk_widget_show (label22);
  gtk_box_pack_start (GTK_BOX (hbox9), label22, FALSE, FALSE, 0);
  gtk_label_set_use_markup (GTK_LABEL (label22), TRUE);

  hbox12 = gtk_hbox_new (FALSE, 10);
  gtk_widget_show (hbox12);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox12, TRUE, TRUE, 0);

  label27 = gtk_label_new (_("<span background=\"brown\" foreground=\"white\" size=\"xx-large\">     \n     \n     \n     \n     \n     \n 2  \n     \n     \n     \n     \n     </span>"));
  gtk_widget_show (label27);
  gtk_box_pack_start (GTK_BOX (hbox12), label27, FALSE, FALSE, 0);
  gtk_label_set_use_markup (GTK_LABEL (label27), TRUE);

  vbox5 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox5);
  gtk_box_pack_start (GTK_BOX (hbox12), vbox5, TRUE, TRUE, 0);

  label33 = gtk_label_new (_("Enter your registration details below"));
  gtk_widget_show (label33);
  gtk_box_pack_start (GTK_BOX (vbox5), label33, TRUE, TRUE, 0);
  gtk_misc_set_alignment (GTK_MISC (label33), 0.07, 0.5);

  label45 = gtk_label_new (_("<b>Required Information</b>"));
  gtk_widget_show (label45);
  gtk_box_pack_start (GTK_BOX (vbox5), label45, TRUE, TRUE, 10);
  gtk_label_set_use_markup (GTK_LABEL (label45), TRUE);

  hbox11 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox11);
  gtk_box_pack_start (GTK_BOX (vbox5), hbox11, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox11), 2);

  label25 = gtk_label_new (_("Username: "));
  gtk_widget_show (label25);
  gtk_box_pack_start (GTK_BOX (hbox11), label25, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label25, 230, -1);
  gtk_misc_set_padding (GTK_MISC (label25), 20, 0);

  register_username_entry = gtk_entry_new ();
  gtk_widget_show (register_username_entry);
  gtk_box_pack_start (GTK_BOX (hbox11), register_username_entry, FALSE, FALSE, 0);
  gtk_widget_set_size_request (register_username_entry, 230, -1);
  gtk_entry_set_max_length (GTK_ENTRY (register_username_entry), 16);

  hbox15 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox15);
  gtk_box_pack_start (GTK_BOX (vbox5), hbox15, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox15), 2);

  label32 = gtk_label_new (_("Password:   "));
  gtk_widget_show (label32);
  gtk_box_pack_start (GTK_BOX (hbox15), label32, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label32, 230, -1);
  gtk_misc_set_padding (GTK_MISC (label32), 20, 0);

  register_password_entry = gtk_entry_new ();
  gtk_widget_show (register_password_entry);
  gtk_box_pack_start (GTK_BOX (hbox15), register_password_entry, FALSE, FALSE, 0);
  gtk_widget_set_size_request (register_password_entry, 230, -1);
  gtk_entry_set_visibility (GTK_ENTRY (register_password_entry), FALSE);
  gtk_entry_set_invisible_char (GTK_ENTRY (register_password_entry), 9679);

  hbox31 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox31);
  gtk_box_pack_start (GTK_BOX (vbox5), hbox31, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox31), 2);

  label58 = gtk_label_new (_("Confirm Password:   "));
  gtk_widget_show (label58);
  gtk_box_pack_start (GTK_BOX (hbox31), label58, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label58, 230, -1);
  gtk_misc_set_padding (GTK_MISC (label58), 20, 0);

  register_password_confirm_entry = gtk_entry_new ();
  gtk_widget_show (register_password_confirm_entry);
  gtk_box_pack_start (GTK_BOX (hbox31), register_password_confirm_entry, FALSE, FALSE, 0);
  gtk_widget_set_size_request (register_password_confirm_entry, 230, -1);
  gtk_entry_set_visibility (GTK_ENTRY (register_password_confirm_entry), FALSE);
  gtk_entry_set_invisible_char (GTK_ENTRY (register_password_confirm_entry), 9679);

  passwords_warning_label = gtk_label_new (_("<span foreground=\"red\">Passwords do not match</span>"));
  gtk_box_pack_start (GTK_BOX (vbox5), passwords_warning_label, TRUE, TRUE, 0);
  gtk_label_set_use_markup (GTK_LABEL (passwords_warning_label), TRUE);

  label46 = gtk_label_new (_("<b>Optional Information</b>"));
  gtk_widget_show (label46);
  gtk_box_pack_start (GTK_BOX (vbox5), label46, TRUE, TRUE, 5);
  gtk_label_set_use_markup (GTK_LABEL (label46), TRUE);

  hbox16 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox16);
  gtk_box_pack_start (GTK_BOX (vbox5), hbox16, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox16), 2);

  label36 = gtk_label_new (_("Email Address:"));
  gtk_widget_show (label36);
  gtk_box_pack_start (GTK_BOX (hbox16), label36, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label36, 230, -1);
  gtk_misc_set_padding (GTK_MISC (label36), 20, 0);

  register_email_entry = gtk_entry_new ();
  gtk_widget_show (register_email_entry);
  gtk_box_pack_start (GTK_BOX (hbox16), register_email_entry, FALSE, FALSE, 0);
  gtk_widget_set_size_request (register_email_entry, 230, -1);

  hbox23 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox23);
  gtk_box_pack_start (GTK_BOX (vbox5), hbox23, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox23), 2);

  label47 = gtk_label_new (_("Website URL:"));
  gtk_widget_show (label47);
  gtk_box_pack_start (GTK_BOX (hbox23), label47, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label47, 230, -1);
  gtk_misc_set_padding (GTK_MISC (label47), 20, 0);

  register_website_entry = gtk_entry_new ();
  gtk_widget_show (register_website_entry);
  gtk_box_pack_start (GTK_BOX (hbox23), register_website_entry, FALSE, FALSE, 0);
  gtk_widget_set_size_request (register_website_entry, 230, -1);
  gtk_tooltips_set_tip (tooltips, register_website_entry, _("Website URL Format:\n\nhttp://www.example.com"), NULL);

  hbox24 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox24);
  gtk_box_pack_start (GTK_BOX (vbox5), hbox24, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox24), 2);

  label48 = gtk_label_new (_("Phone Number: "));
  gtk_widget_show (label48);
  gtk_box_pack_start (GTK_BOX (hbox24), label48, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label48, 230, -1);
  gtk_misc_set_padding (GTK_MISC (label48), 20, 0);

  register_phone_entry = gtk_entry_new ();
  gtk_widget_show (register_phone_entry);
  gtk_box_pack_start (GTK_BOX (hbox24), register_phone_entry, FALSE, FALSE, 0);
  gtk_widget_set_size_request (register_phone_entry, 230, -1);
  gtk_tooltips_set_tip (tooltips, register_phone_entry, _("International phone format \n+xxx-(yyy)-zzz-zzzz\n\nwhere\n\n\txxx \t\tCountry code\n\tyyy \t\tArea or city code\n\tzzz-zzzz \tLocal number\n\nexample: +63-(2)-823-7441"), NULL);

  hbox25 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox25);
  gtk_box_pack_start (GTK_BOX (vbox5), hbox25, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox25), 2);

  label49 = gtk_label_new (_("GSM/SMS Cellphone Number:"));
  gtk_widget_show (label49);
  gtk_box_pack_start (GTK_BOX (hbox25), label49, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label49, 230, -1);
  gtk_misc_set_padding (GTK_MISC (label49), 20, 0);

  register_gsm_entry = gtk_entry_new ();
  gtk_widget_show (register_gsm_entry);
  gtk_box_pack_start (GTK_BOX (hbox25), register_gsm_entry, FALSE, FALSE, 0);
  gtk_widget_set_size_request (register_gsm_entry, 230, -1);
  gtk_tooltips_set_tip (tooltips, register_gsm_entry, _("International GSM/SMS cellular phone format\n+8812345678\n\nwhere\n\n\t88 \t\t  country code\n\t12345678  cellphone number without leading 0.\n\nexample: +639157457547"), NULL);

  page4_share_checkbutton = gtk_check_button_new_with_mnemonic (_("Share my _personal information to other users"));
  gtk_widget_show (page4_share_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox5), page4_share_checkbutton, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (page4_share_checkbutton), TRUE);

  label34 = gtk_label_new (_("It is advisable to write down your password in a sheet of paper, and keep \nit in a safe place."));
  gtk_widget_show (label34);
  gtk_box_pack_start (GTK_BOX (vbox5), label34, FALSE, FALSE, 10);
  gtk_label_set_use_markup (GTK_LABEL (label34), TRUE);

  label31 = gtk_label_new (_("If your finish providing your information, click the \"Send\" button to begin \nregistration"));
  gtk_widget_show (label31);
  gtk_box_pack_start (GTK_BOX (vbox5), label31, FALSE, FALSE, 0);

  hseparator1 = gtk_hseparator_new ();
  gtk_widget_show (hseparator1);
  gtk_box_pack_start (GTK_BOX (vbox4), hseparator1, FALSE, FALSE, 0);

  hseparator2 = gtk_hseparator_new ();
  gtk_widget_show (hseparator2);
  gtk_box_pack_start (GTK_BOX (vbox4), hseparator2, FALSE, FALSE, 0);

  hbuttonbox9 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox9);
  gtk_box_pack_end (GTK_BOX (vbox4), hbuttonbox9, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbuttonbox9), 10);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox9), GTK_BUTTONBOX_END);
  gtk_box_set_spacing (GTK_BOX (hbuttonbox9), 15);

  page4_back_button = gtk_button_new_from_stock ("gtk-go-back");
  gtk_widget_show (page4_back_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox9), page4_back_button);
  gtk_widget_set_size_request (page4_back_button, 87, 36);
  GTK_WIDGET_SET_FLAGS (page4_back_button, GTK_CAN_DEFAULT);

  page4_connect_button = gtk_button_new ();
  gtk_widget_show (page4_connect_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox9), page4_connect_button);
  gtk_widget_set_size_request (page4_connect_button, 87, 36);
  GTK_WIDGET_SET_FLAGS (page4_connect_button, GTK_CAN_DEFAULT);

  page4_send_button_alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (page4_send_button_alignment);
  gtk_container_add (GTK_CONTAINER (page4_connect_button), page4_send_button_alignment);

  hbox34 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox34);
  gtk_container_add (GTK_CONTAINER (page4_send_button_alignment), hbox34);

  page4_send_button_image = gtk_image_new_from_icon_name ("stock_connect-to-url", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (page4_send_button_image);
  gtk_box_pack_start (GTK_BOX (hbox34), page4_send_button_image, FALSE, FALSE, 0);

  page4_send_button_label = gtk_label_new_with_mnemonic ("S_end");
  gtk_widget_show (page4_send_button_label);
  gtk_box_pack_start (GTK_BOX (hbox34), page4_send_button_label, FALSE, FALSE, 0);

  label21 = gtk_label_new (_("label21"));
  gtk_widget_show (label21);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 4), label21);

  vbox6 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox6);
  gtk_container_add (GTK_CONTAINER (notebook), vbox6);

  hbox18 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox18);
  gtk_box_pack_start (GTK_BOX (vbox6), hbox18, FALSE, FALSE, 5);

  image9 = gtk_image_new_from_icon_name ("stock_people", GTK_ICON_SIZE_DIALOG);
  gtk_widget_show (image9);
  gtk_box_pack_start (GTK_BOX (hbox18), image9, FALSE, TRUE, 0);
  gtk_misc_set_padding (GTK_MISC (image9), 30, 0);

  label38 = gtk_label_new (_("<span size=\"x-large\">Ubuntu Live Chat Support 0.3.14</span>\n\"All you need is Love\""));
  gtk_widget_show (label38);
  gtk_box_pack_start (GTK_BOX (hbox18), label38, FALSE, FALSE, 0);
  gtk_label_set_use_markup (GTK_LABEL (label38), TRUE);

  label39 = gtk_label_new (_("Ubuntu Live Chat Support is an interface to communicate to other Ubuntu \nLinux users with the same language & location to gain support interactively \nvia live chat."));
  gtk_widget_show (label39);
  gtk_box_pack_start (GTK_BOX (vbox6), label39, FALSE, TRUE, 10);
  gtk_misc_set_padding (GTK_MISC (label39), 10, 0);

  label40 = gtk_label_new (_("Copyright \302\251 2006 Joel Bryan Juliano"));
  gtk_widget_show (label40);
  gtk_box_pack_start (GTK_BOX (vbox6), label40, FALSE, TRUE, 10);
  gtk_label_set_use_markup (GTK_LABEL (label40), TRUE);
  gtk_misc_set_padding (GTK_MISC (label40), 10, 0);

  hbox19 = gtk_hbox_new (TRUE, 0);
  gtk_widget_show (hbox19);
  gtk_box_pack_end (GTK_BOX (vbox6), hbox19, FALSE, FALSE, 0);

  hbuttonbox12 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox12);
  gtk_box_pack_start (GTK_BOX (hbox19), hbuttonbox12, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbuttonbox12), 10);
  gtk_box_set_spacing (GTK_BOX (hbuttonbox12), 15);

  page5_credits_button = gtk_button_new ();
  gtk_container_add (GTK_CONTAINER (hbuttonbox12), page5_credits_button);
  gtk_widget_set_size_request (page5_credits_button, 87, 36);
  GTK_WIDGET_SET_FLAGS (page5_credits_button, GTK_CAN_DEFAULT);

  alignment4 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment4);
  gtk_container_add (GTK_CONTAINER (page5_credits_button), alignment4);

  hbox20 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox20);
  gtk_container_add (GTK_CONTAINER (alignment4), hbox20);

  image10 = gtk_image_new_from_stock ("gtk-about", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image10);
  gtk_box_pack_start (GTK_BOX (hbox20), image10, FALSE, FALSE, 0);

  label41 = gtk_label_new_with_mnemonic (_("_Credits"));
  gtk_widget_show (label41);
  gtk_box_pack_start (GTK_BOX (hbox20), label41, FALSE, FALSE, 0);

  page5_license_button = gtk_button_new ();
  gtk_widget_show (page5_license_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox12), page5_license_button);
  gtk_widget_set_size_request (page5_license_button, 87, 36);
  GTK_WIDGET_SET_FLAGS (page5_license_button, GTK_CAN_DEFAULT);

  alignment5 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment5);
  gtk_container_add (GTK_CONTAINER (page5_license_button), alignment5);

  hbox26 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox26);
  gtk_container_add (GTK_CONTAINER (alignment5), hbox26);

  image12 = gtk_image_new_from_stock ("gtk-edit", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image12);
  gtk_box_pack_start (GTK_BOX (hbox26), image12, FALSE, FALSE, 0);

  label50 = gtk_label_new_with_mnemonic (_("_License"));
  gtk_widget_show (label50);
  gtk_box_pack_start (GTK_BOX (hbox26), label50, FALSE, FALSE, 0);

  hbuttonbox11 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox11);
  gtk_box_pack_start (GTK_BOX (hbox19), hbuttonbox11, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbuttonbox11), 10);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox11), GTK_BUTTONBOX_END);
  gtk_box_set_spacing (GTK_BOX (hbuttonbox11), 15);

  page5_ok_button = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (page5_ok_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox11), page5_ok_button);
  gtk_widget_set_size_request (page5_ok_button, 87, 36);
  GTK_WIDGET_SET_FLAGS (page5_ok_button, GTK_CAN_DEFAULT);

  label37 = gtk_label_new (_("label37"));
  gtk_widget_show (label37);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 5), label37);

  vbox7 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox7);
  gtk_container_add (GTK_CONTAINER (notebook), vbox7);

  hbox21 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox21);
  gtk_box_pack_start (GTK_BOX (vbox7), hbox21, FALSE, FALSE, 5);

  image11 = gtk_image_new_from_icon_name ("gtk-edit", GTK_ICON_SIZE_DIALOG);
  gtk_widget_show (image11);
  gtk_box_pack_start (GTK_BOX (hbox21), image11, FALSE, TRUE, 0);
  gtk_misc_set_padding (GTK_MISC (image11), 30, 0);

  label44 = gtk_label_new (_("<span size=\"x-large\">License</span>\nGNU General Public License Version 2"));
  gtk_widget_show (label44);
  gtk_box_pack_start (GTK_BOX (hbox21), label44, FALSE, FALSE, 0);
  gtk_label_set_use_markup (GTK_LABEL (label44), TRUE);

  scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow2);
  gtk_box_pack_start (GTK_BOX (vbox7), scrolledwindow2, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_POLICY_AUTOMATIC, GTK_POLICY_NEVER);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_SHADOW_IN);

  license_textview = gtk_text_view_new ();
  gtk_widget_show (license_textview);
  gtk_container_add (GTK_CONTAINER (scrolledwindow2), license_textview);
  gtk_text_buffer_set_text (gtk_text_view_get_buffer (GTK_TEXT_VIEW (license_textview)), _("Licensed under the GNU General Public License Version 2\n\nUbuntu Live Chat Support is free software; you can redistribute it and/or\nmodify it under the terms of the GNU General Public License\nas published by the Free Software Foundation; either version 2\nof the License, or (at your option) any later version.\n\nUbuntu Live Chat Support is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\nGNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License\nalong with this program; if not, write to the Free Software\nFoundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA\n02110-1301, USA.\n"), -1);

  hbox22 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox22);
  gtk_box_pack_end (GTK_BOX (vbox7), hbox22, FALSE, FALSE, 0);

  hbuttonbox14 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox14);
  gtk_box_pack_end (GTK_BOX (hbox22), hbuttonbox14, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbuttonbox14), 10);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox14), GTK_BUTTONBOX_END);
  gtk_box_set_spacing (GTK_BOX (hbuttonbox14), 15);

  page6_back_button = gtk_button_new_from_stock ("gtk-go-back");
  gtk_widget_show (page6_back_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox14), page6_back_button);
  gtk_widget_set_size_request (page6_back_button, 87, 36);
  GTK_WIDGET_SET_FLAGS (page6_back_button, GTK_CAN_DEFAULT);

  label42 = gtk_label_new (_("label42"));
  gtk_widget_show (label42);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 6), label42);

  g_signal_connect ((gpointer) window, "destroy",
                    G_CALLBACK (on_window_destroy),
                    NULL);
  g_signal_connect ((gpointer) page0_about_button, "clicked",
                    G_CALLBACK (on_page0_about_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) page0_cancel_button, "clicked",
                    G_CALLBACK (on_page0_cancel_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) page0_next_button, "clicked",
                    G_CALLBACK (on_page0_next_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) password_entry, "changed",
                    G_CALLBACK (on_password_entry_changed),
                    NULL);
  g_signal_connect ((gpointer) page1_register_button, "clicked",
                    G_CALLBACK (on_page1_register_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) page1_back_button, "clicked",
                    G_CALLBACK (on_page1_back_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) page1_connect_button, "clicked",
                    G_CALLBACK (on_page1_connect_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) unregistered_login_checkbox, "toggled",
                    G_CALLBACK (on_unregistered_login_checkbox_toggled),
                    NULL);
  g_signal_connect ((gpointer) page1_settings_togglebutton, "toggled",
                    G_CALLBACK (on_page1_settings_togglebutton_toggled),
                    NULL);
  g_signal_connect ((gpointer) page2_back_button, "clicked",
                    G_CALLBACK (on_page2_back_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) page2_next_button, "clicked",
                    G_CALLBACK (on_page2_next_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) check_availability_button, "clicked",
                    G_CALLBACK (on_check_availability_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) page3_back_button, "clicked",
                    G_CALLBACK (on_page3_back_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) page3_next_button, "clicked",
                    G_CALLBACK (on_page3_next_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) register_password_entry, "changed",
                    G_CALLBACK (on_register_password_entry_changed),
                    NULL);
  g_signal_connect ((gpointer) register_password_confirm_entry, "changed",
                    G_CALLBACK (on_register_password_confirm_entry_changed),
                    NULL);
  g_signal_connect ((gpointer) page4_back_button, "clicked",
                    G_CALLBACK (on_page4_back_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) page4_connect_button, "clicked",
                    G_CALLBACK (on_page4_connect_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) page5_credits_button, "clicked",
                    G_CALLBACK (on_page5_credits_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) page5_license_button, "clicked",
                    G_CALLBACK (on_page5_license_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) page5_ok_button, "clicked",
                    G_CALLBACK (on_page5_ok_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) page6_back_button, "clicked",
                    G_CALLBACK (on_page6_back_button_clicked),
                    NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (window, window, "window");
  GLADE_HOOKUP_OBJECT (window, notebook, "notebook");
  GLADE_HOOKUP_OBJECT (window, vbox1, "vbox1");
  GLADE_HOOKUP_OBJECT (window, hbox1, "hbox1");
  GLADE_HOOKUP_OBJECT (window, intro_page_logo, "intro_page_logo");
  GLADE_HOOKUP_OBJECT (window, intro_label, "intro_label");
  GLADE_HOOKUP_OBJECT (window, intro_text, "intro_text");
  GLADE_HOOKUP_OBJECT (window, hbox17, "hbox17");
  GLADE_HOOKUP_OBJECT (window, hbuttonbox10, "hbuttonbox10");
  GLADE_HOOKUP_OBJECT (window, page0_about_button, "page0_about_button");
  GLADE_HOOKUP_OBJECT (window, hbuttonbox1, "hbuttonbox1");
  GLADE_HOOKUP_OBJECT (window, page0_cancel_button, "page0_cancel_button");
  GLADE_HOOKUP_OBJECT (window, page0_next_button, "page0_next_button");
  GLADE_HOOKUP_OBJECT (window, page0_next_button_alignment, "page0_next_button_alignment");
  GLADE_HOOKUP_OBJECT (window, hbox2, "hbox2");
  GLADE_HOOKUP_OBJECT (window, page0_next_button_image, "page0_next_button_image");
  GLADE_HOOKUP_OBJECT (window, page0_next_button_label, "page0_next_button_label");
  GLADE_HOOKUP_OBJECT (window, intro_page_tab_label, "intro_page_tab_label");
  GLADE_HOOKUP_OBJECT (window, vbox2, "vbox2");
  GLADE_HOOKUP_OBJECT (window, hbox3, "hbox3");
  GLADE_HOOKUP_OBJECT (window, account_page_logo, "account_page_logo");
  GLADE_HOOKUP_OBJECT (window, label7, "label7");
  GLADE_HOOKUP_OBJECT (window, account_label, "account_label");
  GLADE_HOOKUP_OBJECT (window, account_page_fixed, "account_page_fixed");
  GLADE_HOOKUP_OBJECT (window, username_entry, "username_entry");
  GLADE_HOOKUP_OBJECT (window, password_entry, "password_entry");
  GLADE_HOOKUP_OBJECT (window, account_password_label, "account_password_label");
  GLADE_HOOKUP_OBJECT (window, account_username_label, "account_username_label");
  GLADE_HOOKUP_OBJECT (window, hbox6, "hbox6");
  GLADE_HOOKUP_OBJECT (window, hbuttonbox7, "hbuttonbox7");
  GLADE_HOOKUP_OBJECT (window, page1_register_button, "page1_register_button");
  GLADE_HOOKUP_OBJECT (window, page1_register_button_alignment, "page1_register_button_alignment");
  GLADE_HOOKUP_OBJECT (window, page1_register_button_hbox, "page1_register_button_hbox");
  GLADE_HOOKUP_OBJECT (window, page1_register_button_image, "page1_register_button_image");
  GLADE_HOOKUP_OBJECT (window, page1_register_button_label, "page1_register_button_label");
  GLADE_HOOKUP_OBJECT (window, hbuttonbox6, "hbuttonbox6");
  GLADE_HOOKUP_OBJECT (window, page1_back_button, "page1_back_button");
  GLADE_HOOKUP_OBJECT (window, page1_connect_button, "page1_connect_button");
  GLADE_HOOKUP_OBJECT (window, page1_connect_button_alignment, "page1_connect_button_alignment");
  GLADE_HOOKUP_OBJECT (window, hbox32, "hbox32");
  GLADE_HOOKUP_OBJECT (window, page1_connect_button_image, "page1_connect_button_image");
  GLADE_HOOKUP_OBJECT (window, page1_connect_button_label, "page1_connect_button_label");
  GLADE_HOOKUP_OBJECT (window, account_page_fixed2, "account_page_fixed2");
  GLADE_HOOKUP_OBJECT (window, settings_notebook, "settings_notebook");
  GLADE_HOOKUP_OBJECT (window, empty_label, "empty_label");
  GLADE_HOOKUP_OBJECT (window, hbox33, "hbox33");
  GLADE_HOOKUP_OBJECT (window, vbox10, "vbox10");
  GLADE_HOOKUP_OBJECT (window, page1_settings_default_radiobutton, "page1_settings_default_radiobutton");
  GLADE_HOOKUP_OBJECT (window, settings_default_layout_image, "settings_default_layout_image");
  GLADE_HOOKUP_OBJECT (window, vbox11, "vbox11");
  GLADE_HOOKUP_OBJECT (window, page1_settings_alternative_radiobutton, "page1_settings_alternative_radiobutton");
  GLADE_HOOKUP_OBJECT (window, settings_alternative_layout_image, "settings_alternative_layout_image");
  GLADE_HOOKUP_OBJECT (window, settings_page_label, "settings_page_label");
  GLADE_HOOKUP_OBJECT (window, unregistered_login_checkbox, "unregistered_login_checkbox");
  GLADE_HOOKUP_OBJECT (window, unregistered_login_label_message, "unregistered_login_label_message");
  GLADE_HOOKUP_OBJECT (window, page1_settings_togglebutton, "page1_settings_togglebutton");
  GLADE_HOOKUP_OBJECT (window, settings_button_alignment, "settings_button_alignment");
  GLADE_HOOKUP_OBJECT (window, page1_settings_button_hbox, "page1_settings_button_hbox");
  GLADE_HOOKUP_OBJECT (window, page1_settings_button_image, "page1_settings_button_image");
  GLADE_HOOKUP_OBJECT (window, page1_settings_button_label, "page1_settings_button_label");
  GLADE_HOOKUP_OBJECT (window, account_page_tab_label, "account_page_tab_label");
  GLADE_HOOKUP_OBJECT (window, vbox3, "vbox3");
  GLADE_HOOKUP_OBJECT (window, hbox5, "hbox5");
  GLADE_HOOKUP_OBJECT (window, image5, "image5");
  GLADE_HOOKUP_OBJECT (window, label12, "label12");
  GLADE_HOOKUP_OBJECT (window, scrolledwindow1, "scrolledwindow1");
  GLADE_HOOKUP_OBJECT (window, textview1, "textview1");
  GLADE_HOOKUP_OBJECT (window, hbuttonbox8, "hbuttonbox8");
  GLADE_HOOKUP_OBJECT (window, page2_back_button, "page2_back_button");
  GLADE_HOOKUP_OBJECT (window, page2_next_button, "page2_next_button");
  GLADE_HOOKUP_OBJECT (window, alignment3, "alignment3");
  GLADE_HOOKUP_OBJECT (window, hbox8, "hbox8");
  GLADE_HOOKUP_OBJECT (window, image7, "image7");
  GLADE_HOOKUP_OBJECT (window, label20, "label20");
  GLADE_HOOKUP_OBJECT (window, label35, "label35");
  GLADE_HOOKUP_OBJECT (window, label3, "label3");
  GLADE_HOOKUP_OBJECT (window, vbox8, "vbox8");
  GLADE_HOOKUP_OBJECT (window, hbox27, "hbox27");
  GLADE_HOOKUP_OBJECT (window, image13, "image13");
  GLADE_HOOKUP_OBJECT (window, label52, "label52");
  GLADE_HOOKUP_OBJECT (window, hbox28, "hbox28");
  GLADE_HOOKUP_OBJECT (window, label53, "label53");
  GLADE_HOOKUP_OBJECT (window, vbox9, "vbox9");
  GLADE_HOOKUP_OBJECT (window, label54, "label54");
  GLADE_HOOKUP_OBJECT (window, hbox29, "hbox29");
  GLADE_HOOKUP_OBJECT (window, label55, "label55");
  GLADE_HOOKUP_OBJECT (window, nick_availability_entry, "nick_availability_entry");
  GLADE_HOOKUP_OBJECT (window, check_availability_button, "check_availability_button");
  GLADE_HOOKUP_OBJECT (window, label56, "label56");
  GLADE_HOOKUP_OBJECT (window, label59, "label59");
  GLADE_HOOKUP_OBJECT (window, hseparator3, "hseparator3");
  GLADE_HOOKUP_OBJECT (window, hbuttonbox15, "hbuttonbox15");
  GLADE_HOOKUP_OBJECT (window, page3_back_button, "page3_back_button");
  GLADE_HOOKUP_OBJECT (window, page3_next_button, "page3_next_button");
  GLADE_HOOKUP_OBJECT (window, alignment6, "alignment6");
  GLADE_HOOKUP_OBJECT (window, hbox30, "hbox30");
  GLADE_HOOKUP_OBJECT (window, image14, "image14");
  GLADE_HOOKUP_OBJECT (window, label57, "label57");
  GLADE_HOOKUP_OBJECT (window, label51, "label51");
  GLADE_HOOKUP_OBJECT (window, vbox4, "vbox4");
  GLADE_HOOKUP_OBJECT (window, hbox9, "hbox9");
  GLADE_HOOKUP_OBJECT (window, image8, "image8");
  GLADE_HOOKUP_OBJECT (window, label22, "label22");
  GLADE_HOOKUP_OBJECT (window, hbox12, "hbox12");
  GLADE_HOOKUP_OBJECT (window, label27, "label27");
  GLADE_HOOKUP_OBJECT (window, vbox5, "vbox5");
  GLADE_HOOKUP_OBJECT (window, label33, "label33");
  GLADE_HOOKUP_OBJECT (window, label45, "label45");
  GLADE_HOOKUP_OBJECT (window, hbox11, "hbox11");
  GLADE_HOOKUP_OBJECT (window, label25, "label25");
  GLADE_HOOKUP_OBJECT (window, register_username_entry, "register_username_entry");
  GLADE_HOOKUP_OBJECT (window, hbox15, "hbox15");
  GLADE_HOOKUP_OBJECT (window, label32, "label32");
  GLADE_HOOKUP_OBJECT (window, register_password_entry, "register_password_entry");
  GLADE_HOOKUP_OBJECT (window, hbox31, "hbox31");
  GLADE_HOOKUP_OBJECT (window, label58, "label58");
  GLADE_HOOKUP_OBJECT (window, register_password_confirm_entry, "register_password_confirm_entry");
  GLADE_HOOKUP_OBJECT (window, passwords_warning_label, "passwords_warning_label");
  GLADE_HOOKUP_OBJECT (window, label46, "label46");
  GLADE_HOOKUP_OBJECT (window, hbox16, "hbox16");
  GLADE_HOOKUP_OBJECT (window, label36, "label36");
  GLADE_HOOKUP_OBJECT (window, register_email_entry, "register_email_entry");
  GLADE_HOOKUP_OBJECT (window, hbox23, "hbox23");
  GLADE_HOOKUP_OBJECT (window, label47, "label47");
  GLADE_HOOKUP_OBJECT (window, register_website_entry, "register_website_entry");
  GLADE_HOOKUP_OBJECT (window, hbox24, "hbox24");
  GLADE_HOOKUP_OBJECT (window, label48, "label48");
  GLADE_HOOKUP_OBJECT (window, register_phone_entry, "register_phone_entry");
  GLADE_HOOKUP_OBJECT (window, hbox25, "hbox25");
  GLADE_HOOKUP_OBJECT (window, label49, "label49");
  GLADE_HOOKUP_OBJECT (window, register_gsm_entry, "register_gsm_entry");
  GLADE_HOOKUP_OBJECT (window, page4_share_checkbutton, "page4_share_checkbutton");
  GLADE_HOOKUP_OBJECT (window, label34, "label34");
  GLADE_HOOKUP_OBJECT (window, label31, "label31");
  GLADE_HOOKUP_OBJECT (window, hseparator1, "hseparator1");
  GLADE_HOOKUP_OBJECT (window, hseparator2, "hseparator2");
  GLADE_HOOKUP_OBJECT (window, hbuttonbox9, "hbuttonbox9");
  GLADE_HOOKUP_OBJECT (window, page4_back_button, "page4_back_button");
  GLADE_HOOKUP_OBJECT (window, page4_connect_button, "page4_connect_button");
  GLADE_HOOKUP_OBJECT (window, page4_send_button_alignment, "page4_send_button_alignment");
  GLADE_HOOKUP_OBJECT (window, hbox34, "hbox34");
  GLADE_HOOKUP_OBJECT (window, page4_send_button_image, "page4_send_button_image");
  GLADE_HOOKUP_OBJECT (window, page4_send_button_label, "page4_send_button_label");
  GLADE_HOOKUP_OBJECT (window, label21, "label21");
  GLADE_HOOKUP_OBJECT (window, vbox6, "vbox6");
  GLADE_HOOKUP_OBJECT (window, hbox18, "hbox18");
  GLADE_HOOKUP_OBJECT (window, image9, "image9");
  GLADE_HOOKUP_OBJECT (window, label38, "label38");
  GLADE_HOOKUP_OBJECT (window, label39, "label39");
  GLADE_HOOKUP_OBJECT (window, label40, "label40");
  GLADE_HOOKUP_OBJECT (window, hbox19, "hbox19");
  GLADE_HOOKUP_OBJECT (window, hbuttonbox12, "hbuttonbox12");
  GLADE_HOOKUP_OBJECT (window, page5_credits_button, "page5_credits_button");
  GLADE_HOOKUP_OBJECT (window, alignment4, "alignment4");
  GLADE_HOOKUP_OBJECT (window, hbox20, "hbox20");
  GLADE_HOOKUP_OBJECT (window, image10, "image10");
  GLADE_HOOKUP_OBJECT (window, label41, "label41");
  GLADE_HOOKUP_OBJECT (window, page5_license_button, "page5_license_button");
  GLADE_HOOKUP_OBJECT (window, alignment5, "alignment5");
  GLADE_HOOKUP_OBJECT (window, hbox26, "hbox26");
  GLADE_HOOKUP_OBJECT (window, image12, "image12");
  GLADE_HOOKUP_OBJECT (window, label50, "label50");
  GLADE_HOOKUP_OBJECT (window, hbuttonbox11, "hbuttonbox11");
  GLADE_HOOKUP_OBJECT (window, page5_ok_button, "page5_ok_button");
  GLADE_HOOKUP_OBJECT (window, label37, "label37");
  GLADE_HOOKUP_OBJECT (window, vbox7, "vbox7");
  GLADE_HOOKUP_OBJECT (window, hbox21, "hbox21");
  GLADE_HOOKUP_OBJECT (window, image11, "image11");
  GLADE_HOOKUP_OBJECT (window, label44, "label44");
  GLADE_HOOKUP_OBJECT (window, scrolledwindow2, "scrolledwindow2");
  GLADE_HOOKUP_OBJECT (window, license_textview, "license_textview");
  GLADE_HOOKUP_OBJECT (window, hbox22, "hbox22");
  GLADE_HOOKUP_OBJECT (window, hbuttonbox14, "hbuttonbox14");
  GLADE_HOOKUP_OBJECT (window, page6_back_button, "page6_back_button");
  GLADE_HOOKUP_OBJECT (window, label42, "label42");
  GLADE_HOOKUP_OBJECT_NO_REF (window, tooltips, "tooltips");

  return window;
}

