#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

extern GtkWidget *window, *notebook;
extern GtkWidget *username_entry;
extern GtkWidget *password_entry;
extern GtkWidget *register_username_entry;
extern GtkWidget *register_password_entry;
extern GtkWidget *register_email_entry;
extern GtkWidget *page4_connect_button;
extern GtkWidget *register_website_entry;
extern GtkWidget *register_phone_entry;
extern GtkWidget *register_gsm_entry;
extern GtkWidget *register_password_confirm_entry;
extern GtkWidget *nick_availability_entry;
extern GtkWidget *page1_connect_button;
extern GtkWidget *unregistered_login_label_message;
extern GtkWidget *unregistered_login_checkbox;
extern GtkWidget *settings_notebook;
extern GtkWidget *passwords_warning_label;
extern GtkWidget *page1_settings_togglebutton;
extern GtkWidget *page4_share_checkbutton;
extern GtkWidget *page1_settings_alternative_radiobutton;
extern GtkWidget *page1_settings_default_radiobutton;

void
on_page0_about_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
notebook = lookup_widget(GTK_WIDGET(window), "notebook");
gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), 5);
}


void
on_page0_cancel_button_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
g_print("NULL\n");
g_print("NULL\n");
g_print("NULL\n");
g_print("NULL\n");
g_print("NULL\n");
g_print("NULL\n");
g_print("NULL\n");
g_print("NULL\n");
g_print("exit\n");
g_print("NULL\n");
gtk_main_quit();
}


void
on_page0_next_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
gtk_widget_set_sensitive (page1_connect_button, FALSE);
notebook = lookup_widget(GTK_WIDGET(window), "notebook");
gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), 1);
}


void
on_page1_register_button_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
notebook = lookup_widget(GTK_WIDGET(window), "notebook");
gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), 2);
}


void
on_page1_back_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
notebook = lookup_widget(GTK_WIDGET(window), "notebook");
gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), 0);
}


void
on_page1_connect_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
const gchar *nick;
const gchar *password;

nick = gtk_entry_get_text(GTK_ENTRY(username_entry));
password = gtk_entry_get_text(GTK_ENTRY(password_entry));

puts(nick);
puts(password);
g_print("NULL\n");
g_print("NULL\n");
g_print("NULL\n");
g_print("NULL\n");
g_print("NULL\n");
g_print("NULL\n");
if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (unregistered_login_checkbox))) 
  {
g_print("unregistered login\n");
  } else {
g_print("registered login\n");
}

if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (page1_settings_alternative_radiobutton))) 
  {
g_print("use alternative layout\n");
} else {
g_print("use default layout\n");
}
gtk_main_quit();
}

void
on_page2_back_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (unregistered_login_checkbox))) 
  {
gtk_widget_set_sensitive (page1_connect_button, TRUE);
  } else {
gtk_widget_set_sensitive (page1_connect_button, FALSE);
}
notebook = lookup_widget(GTK_WIDGET(window), "notebook");
gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), 1);
}


void
on_page2_next_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
notebook = lookup_widget(GTK_WIDGET(window), "notebook");
gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), 3);
}


void
on_check_availability_button_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
const gchar *desired_nick;

desired_nick = gtk_entry_get_text(GTK_ENTRY(nick_availability_entry));
g_print("NULL\n");
g_print("NULL\n");
puts(desired_nick);
g_print("NULL\n");
g_print("NULL\n");
g_print("NULL\n");
g_print("NULL\n");
g_print("NULL\n");
g_print("check availability\n");
g_print("NULL\n");
g_print("NULL\n");
gtk_main_quit();
}

void
on_page3_back_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
notebook = lookup_widget(GTK_WIDGET(window), "notebook");
gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), 2);
}


void
on_page3_next_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
const gchar *nullchar;
const gchar *defined_nickname;
nullchar = "";
gtk_entry_set_text(GTK_ENTRY (register_password_entry), nullchar);
gtk_entry_set_text(GTK_ENTRY (register_password_confirm_entry), nullchar);
gtk_widget_set_sensitive (page4_connect_button, FALSE);
gtk_widget_set_sensitive (register_username_entry, FALSE);
gtk_widget_hide(passwords_warning_label);
defined_nickname = gtk_entry_get_text(GTK_ENTRY(nick_availability_entry));
gtk_entry_set_text(GTK_ENTRY (register_username_entry), defined_nickname);

notebook = lookup_widget(GTK_WIDGET(window), "notebook");
gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), 4);
}


void
on_page4_back_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
notebook = lookup_widget(GTK_WIDGET(window), "notebook");
gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), 3);
}

void freenode_register_output() 
{
const gchar *register_username;
const gchar *register_password;
const gchar *register_email;
const gchar *register_website;
const gchar *register_phone;
const gchar *register_gsm;

register_username = gtk_entry_get_text(GTK_ENTRY(register_username_entry));
register_password = gtk_entry_get_text(GTK_ENTRY(register_password_confirm_entry));
register_email = gtk_entry_get_text(GTK_ENTRY(register_email_entry));
register_website = gtk_entry_get_text(GTK_ENTRY(register_website_entry));
register_phone = gtk_entry_get_text(GTK_ENTRY(register_phone_entry));
register_gsm = gtk_entry_get_text(GTK_ENTRY(register_gsm_entry));

g_print("NULL\n");
g_print("NULL\n");
puts(register_username);
puts(register_password);
puts(register_email);
puts(register_website);
puts(register_phone);
puts(register_gsm);
g_print("send registration\n");
if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (page4_share_checkbutton))) 
  {
g_print("share my information\n");
  } else {
g_print("hide my information\n");
}
gtk_main_quit();
}

void
on_page4_connect_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
freenode_register_output();
gtk_main_quit();
}

void
on_window_destroy                      (GtkObject       *object,
                                        gpointer         user_data)
{
g_print("NULL\n");
g_print("NULL\n");
g_print("NULL\n");
g_print("NULL\n");
g_print("NULL\n");
g_print("NULL\n");
g_print("NULL\n");
g_print("NULL\n");
g_print("exit\n");
g_print("NULL\n");
gtk_main_quit();
}

void
on_page5_credits_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
notebook = lookup_widget(GTK_WIDGET(window), "notebook");
gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), 6);
}


void
on_page5_license_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
notebook = lookup_widget(GTK_WIDGET(window), "notebook");
gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), 6);
}


void
on_page5_ok_button_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
notebook = lookup_widget(GTK_WIDGET(window), "notebook");
gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), 0);
}


void
on_page6_back_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
notebook = lookup_widget(GTK_WIDGET(window), "notebook");
gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), 5);
}


void
on_register_password_confirm_entry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
const gchar *register_password_entry_first;
const gchar *register_password_entry_confirm;
const gchar *nullchar;
nullchar = "";

register_password_entry_first = gtk_entry_get_text(GTK_ENTRY(register_password_entry));
register_password_entry_confirm = gtk_entry_get_text(GTK_ENTRY(register_password_confirm_entry));

if (strcmp (register_password_entry_first, register_password_entry_confirm) == 0)
{
  gtk_widget_hide(passwords_warning_label);
  gtk_widget_set_sensitive (page4_connect_button, TRUE);
} 
else {
  gtk_widget_show(passwords_warning_label);
  gtk_widget_set_sensitive (page4_connect_button, FALSE);
}

if (strcmp (register_password_entry_confirm, nullchar) == 0)
{
  gtk_widget_show(passwords_warning_label);
  gtk_widget_set_sensitive (page4_connect_button, FALSE);
} 

if (strcmp (register_password_entry_first, nullchar) == 0)
{
  gtk_widget_show(passwords_warning_label);
  gtk_widget_set_sensitive (page4_connect_button, FALSE);
} 

}


void
on_password_entry_changed              (GtkEditable     *editable,
                                        gpointer         user_data)
{
const gchar *get_password_entry;
const gchar *nullchar;
nullchar = "";

get_password_entry = gtk_entry_get_text(GTK_ENTRY(password_entry));

if (strcmp (get_password_entry, nullchar) == 0)
{
  gtk_widget_set_sensitive (page1_connect_button, FALSE);
} else {
  gtk_widget_set_sensitive (page1_connect_button, TRUE);
}

}


void
on_unregistered_login_checkbox_toggled (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
const gchar *nullchar;
nullchar = "";

if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (unregistered_login_checkbox))) 
  {
  gtk_entry_set_text(GTK_ENTRY (password_entry), nullchar);
  gtk_widget_set_sensitive (page1_connect_button, TRUE);
  gtk_widget_set_sensitive (password_entry, FALSE);
  gtk_widget_show (unregistered_login_label_message);
} else { 
  gtk_entry_set_text(GTK_ENTRY (password_entry), nullchar);
  gtk_widget_set_sensitive (page1_connect_button, FALSE);
  gtk_widget_set_sensitive (password_entry, TRUE);
  gtk_widget_hide (unregistered_login_label_message);
}

}


void
on_register_password_entry_changed     (GtkEditable     *editable,
                                        gpointer         user_data)
{
const gchar *register_password_entry_first;
const gchar *register_password_entry_confirm;
const gchar *nullchar;
nullchar = "";

register_password_entry_first = gtk_entry_get_text(GTK_ENTRY(register_password_entry));
register_password_entry_confirm = gtk_entry_get_text(GTK_ENTRY(register_password_confirm_entry));

if (strcmp (register_password_entry_first, register_password_entry_confirm) == 0)
{
  gtk_widget_hide(passwords_warning_label);
  gtk_widget_set_sensitive (page4_connect_button, TRUE);
} 
else {
  gtk_widget_show(passwords_warning_label);
  gtk_widget_set_sensitive (page4_connect_button, FALSE);
}

if (strcmp (register_password_entry_confirm, nullchar) == 0)
{
  gtk_widget_show(passwords_warning_label);
  gtk_widget_set_sensitive (page4_connect_button, FALSE);
} 

if (strcmp (register_password_entry_first, nullchar) == 0)
{
  gtk_widget_show(passwords_warning_label);
  gtk_widget_set_sensitive (page4_connect_button, FALSE);
} 

}


void
on_page1_settings_togglebutton_toggled (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (page1_settings_togglebutton))) 
  {
settings_notebook = lookup_widget(GTK_WIDGET(window), "settings_notebook");
gtk_notebook_set_current_page(GTK_NOTEBOOK(settings_notebook), 1);
  }
else
  {
settings_notebook = lookup_widget(GTK_WIDGET(window), "settings_notebook");
gtk_notebook_set_current_page(GTK_NOTEBOOK(settings_notebook), 0);
  }
}

