#
# ===== NW Configurator Core v.0.2 =====
#
# This is simple program that configures the
# "New Wave pixmap theme"
# in an easy way.
# 
# Anton Kerezov <ankere@gmail.com>
# License GPL v3.0

import string
import os.path
import io
import gtk


class GtkRcFile:
    """A class to handle Gtkrc files """
    mFileContent =  []
    mBackupContent = []
    mHasContent = False
    mNWC_BStart = "#---NWC-START---#" # Block start tag
    mNWC_BEnd = "#---NWC-END---#"     # Block end tag


    def __init__(self, filename=""):
        """ Constructor that inits the class. 
        =================================================================================
        filename = the gtkrc file that would be further processed"""
        self.filename = filename
        # This is the main resource of the class 
        # that contains the data needed to modify 
        # the theme appearance.
        self.mHasContent = False
        

    def load_file(self):
        """Load the file you have specified in the Ctor. 
        =================================================================================
        If load fails False is returned else True.
        """
        root = False
        #Check the filename
        if self.filename == '' :
            return False
        if os.path.exists(self.filename) == False:
            return False
        if self.filename.find("/usr/share/themes/") != -1:
            root = True
        
        #load the file to a string list
        try:
            if root:
                #make the file readable
                os.system("gksu chmod a=rx \"" + self.filename+"\"")
                
            rc_file = open(self.filename, "r")
            self.mFileContent = rc_file.readlines()

            rc_file.close()
            
            if root:
                #bring back the root permissions
                os.system("gksu chown root \"" + self.filename+"\"")
            
            #make a copy of the contents so we could restore if needed            
            self.mBackupContent = self.mFileContent[:]
        
            # Set the flag so that we can save
            self.mHasContent = True
            return True
        except Exception as inst: # handle exceptions here
            print type(inst)     # the exception instance
            print inst.args      # arguments stored in .args
            print inst           # __str__ allows args to printed directly

            print "IO error while trying to open and read the file '", self.filename, "' \n"
            return False
        
    
    def save_file(self):
        """ Save any changes to the file from the Ctor. 
        =================================================================================
        If save fails False is returned else True.
        """
        # We have checked the filename and file contents in load_file
        # so of the flag is True we could proceed normally
        if self.mHasContent == False:
            return False
            
        root = False
        # simple check for root acces required
        if self.filename.find("/usr/share/themes") != -1:
             root = True
        
        try:
            if not root:
                rc_file = open(self.filename, "w")

                rc_file.writelines(self.mFileContent)
                rc_file.close()
            else:
                #get the name of the file
                local_file = os.path.basename(self.filename)

                rc_file = open(local_file , "w")
                rc_file.writelines(self.mFileContent)
                rc_file.close()
                
                #copy the file to the actual location with root password asked
                os.system("gksu cp " +local_file+ " \"" +self.filename+ "\"")
                
                #remove the local file
                os.remove(local_file)
                
            return True
        except Exception as inst: # handle exceptions here
            print type(inst)     # the exception instance
            print inst.args      # arguments stored in .args
            print inst           # __str__ allows args to printed directly
            print "Could not save file to '", self.filename, "' \n"
            return False
        

    def get_filename(self):
        """ Returns the filename with which the class is initialised. 
        """
        return self.filename
    
        
    def restore_file_data(self):
        """ Restores the file contents to it's original state of first loading.
        """
        self.mFileContent = self.mBackupContent[:]
    
    
    def modify_first_line(self, aOriginal= None, aModified= None):
        """For a given original line find and replace with the modified version.
        ===============================================================================
        aOriginal = The original line to be looked for.
        aModified = The line that would replace aOriginal if match is found in the file
        The function exits after a match is found and replaced.
        """
        aOriginal = self.__strip_internal(aOriginal)
        if aOriginal == None and aModified == None:
            return False
        # I try to keep the originals stripped
        elif aOriginal == self.__strip_internal(aModified):
            return True
        else:
            i = 0
            in_nwc_block = False #Wether the reading is in nwc block
            
            for line in self.mFileContent:
                #remove unwanted spaces
                line = self.__strip_internal(line)
                
                #check for tags
                if line == self.mNWC_BStart:
                    in_nwc_block = True
                elif line == self.mNWC_BEnd:
                    in_nwc_block = False
                    
                #skip ahead
                if in_nwc_block == False: 
                    i = i+1
                    continue
                #remove comments
                line = self.__remove_comments(line)
                # Only replace if the found match is in editable block    
                if (line == aOriginal): # and (in_nwc_block == True):
                    self.mFileContent[i] = aModified + "\n"
                    return True
                
                
                i = i+1


    def modify_line(self, aOriginal= None, aModified= None):
        """For a given original line find and replace with the modified version.
        ===============================================================================
        aOriginal = The original line to be looked for.
        aModified = The line that would replace aOriginal if match is found in the file
        """
        aOriginal = self.__strip_internal(aOriginal)
        if aOriginal == None and aModified == None:
            return False
        elif aOriginal == self.__strip_internal(aModified):
            return True
        else:
            i = 0
            in_nwc_block = False #Wether the reading is in nwc block
            has_mods = False     # if there are no chnages then the replace was not successful
            
            
            for line in self.mFileContent:
                #remove unwanted spaces
                line = self.__strip_internal(line)
                
                
                #check for block tags
                if line == self.mNWC_BStart:
                    in_nwc_block = True
                if line == self.mNWC_BEnd:
                    in_nwc_block = False
                    
                #skip ahead
                if in_nwc_block == False:
                    i = i+1
                    continue

                line = self.__remove_comments(line)

                # Only replace if the found match is in editable block 
                if (line == aOriginal): # and (in_nwc_block == True):
                    self.mFileContent[i] = aModified + "\n"
                    has_mods = True
                    
                i = i+1
            
            if has_mods:    
                return True
            else: return False
            
    def modify_color_line(self, aOriginal= None, aModified= None):
        """For a given original line find and replace with the modified version. This 
           version is specific for color modifications.
        ===============================================================================
        aOriginal = The original line to be looked for.
        aModified = The line that would replace aOriginal if match is found in the file
        """
        aOriginal = self.__strip_internal(aOriginal)
        if aOriginal == None and aModified == None:
            return False
        elif aOriginal == self.__strip_internal(aModified):
            return True
        else:
            i = 0
            in_nwc_block = False #Wether the reading is in nwc block
            has_mods = False     # if there are no chnages then the replace was not successful
            
            
            for line in self.mFileContent:
                #remove unwanted spaces
                line = self.__strip_internal(line)
                
                
                #check for block tags
                if line == self.mNWC_BStart:
                    in_nwc_block = True
                if line == self.mNWC_BEnd:
                    in_nwc_block = False
                    
                #skip ahead
                if in_nwc_block == False:
                    i = i+1
                    continue

                # Only replace if the found match is in editable block 
                if line.find(aOriginal) != -1: # and (in_nwc_block == True):
                    self.mFileContent[i] = aModified + "\n"
                    has_mods = True
                    
                i = i+1
            
            if has_mods:    
                return True
            else: return False
    

    def comment_line(self, aOriginal, aCommentOut):
        """Comments out the line in aOriginal according to aCommentOut flag. 
        =================================================================================
        If aCommentOut = true then the line will be commented if it is not and vice versa.
        """
        #copy is used to presevre spaces and tabs
        copyOriginal = aOriginal
        aOriginal = self.__strip_internal(aOriginal)
        if aOriginal == None:
            return False
        elif aOriginal == self.__strip_internal(aCommentOut):
            return True
        else:
            i = 0
            in_nwc_block = False #Wether the reading is in nwc block
            has_mods = False     # if there are no chnages then the replace was not successful
            
            for line in self.mFileContent:
                #remove unwanted spaces
                line = self.__strip_internal(line)
                
                #check for block tags
                if line == self.mNWC_BStart:
                    in_nwc_block = True
                if line == self.mNWC_BEnd:
                    in_nwc_block = False
        
                #skip ahead
                if in_nwc_block == False:
                    i = i+1
                    continue
                # Only replace if the found match is in editable block 
                if (line == aOriginal): # and (in_nwc_block == True):
                    if line.find("#") == 0 and aCommentOut == True:
                        #Line already a comment
                        Modified = copyOriginal
                    #this is not the best check as at the end of l
                    #ine there could be other comment
                    elif line.find("#") == 0 and aCommentOut == False:
                        #re,ove any unwanted spaces
                        copyOriginal = copyOriginal.strip()
                        #remove the comment
                        Modified = copyOriginal.lstrip('#')
                    elif line.find("#") != 0 and aCommentOut == True:
                        #add comment
                        Modified = "#" + copyOriginal
                    elif line.find("#") != 0 and aCommentOut == False:
                        #add comment
                        Modified = copyOriginal
                    else: #preserve the original
                        Modified = copyOriginal
    
                    if Modified.find("\n") != -1:
                        self.mFileContent[i] = Modified
                    else:
                        self.mFileContent[i] = Modified + "\n"
                    
                    has_mods = True

                i = i+1
                
            if has_mods:    
                return True
            else: return False
    

    def change_style(self, aOld = None, aNew= None):
        """ Change all lines from the old style to the new one
        =================================================================================
        aOld = The old rc style name that is currently applied.
        aNew = The new one that will replace the old one.
        """
        hasChanged = False
        
        if aOld == None or aNew == None:
            return False
        elif self.__strip_internal(aOld) == self.__strip_internal(aNew):
            return True

        else:
            i = 0
            
            # Add the style prefix and quotes
            aOld = "style \"" + aOld + "\""
            aNew = "style \"" + aNew + "\""
            
            #aOld = self.__strip_internal(aOld)
            in_nwc_block = False #Wether the reading is in nwc block
            
            for line in self.mFileContent:
                #remove unwanted spaces
                line_s = self.__strip_internal(line)
                
                #check for block tags
                if line_s == self.mNWC_BStart:
                    in_nwc_block = True
                if line_s == self.mNWC_BEnd:
                    in_nwc_block = False
                
                #skip ahead
                if in_nwc_block == False:
                    i = i+1 
                    continue 
                            
                # Check if the stripped line contains the stripped text
                if line.find(aOld) != -1:
                    self.mFileContent[i] = line.replace(aOld, aNew, 1)
                    if hasChanged == False: hasChanged = True
                    
                i = i+1         
        
        return hasChanged
    
    
    def get_style_name(self, aWidgetMatch):
        """Get the style name of the requested widget match. 
        =================================================================================
        aWidgetMatch = the name we use to apply styles to gtk objects in gtkrc
        """
        line = self.__lookup_line(aWidgetMatch)
        lineList = line.partition("style")
        
        # returns empty if no match found
        # handle this in calling method/func
        line = self.__strip(lineList[2])
        return self.__strip_quotes(line)
       
    
    def find_line(self, aLineText):
        """Search for a given line or phrase in the contents of the 
        gtkrc file and return it as a result.
        =================================================================================
        Empty string means no match is found.
        """
        line = self.__lookup_line(aLineText)
        return line
    

    def find_line_noNWC(self, aLineText):
        """Search for a given line or phrase in the contents of the 
        gtkrc file and return it as a result.
        This method is not limited by the NWC block tags
        =================================================================================
        Empty string means no match is found.
        """
        line = self.__lookup_line_noNWC(aLineText)
        return line
        
        
    def theme_version(self, aVersion):
        """Check the version of the file loaded. 
        =================================================================================
        Use only major versions 0.8 or 0.9 to specify a range of whole release or 
        0.8.1, 0.9.3 for specific ones. You may even use 0. or 1. as v_str. 
        This is faster than theme_version_range method but more inaccurate.
        """
        ver = self.__lookup_line(aVersion)
        if ver != '':
            return True
        else:
            return False
        
        
    def theme_version_range(self, aFrom, aTo):
        """Check if the version of the file loaded is between the given values. 
        =================================================================================
        aFrom = The minimum (starting) version number.
        aTo = The maximum (final) version number.
        aFrom and aTo are alsp included in the check so if you specify 0.8.1 as 
        min and 0.8.5 as max the result will be true.
        """
        ver = self.__lookup_line("Version:")
        print ver
        
        if ver != '':
            #get the file version number and date
            ver = ver.partition(":")[2]
            #get the bare version string and use the date bracket [ for sep
            ver = ver.partition("[")[0]
            ver = self.__strip(ver)
            # compare it with the given values
            # strings compare similar to digits when 
            #they are written in special format e.g. 0.8.2 < 0.8.3
            if ver >= aFrom and ver <= aTo:
                return True
            else:
                return False
        else:
            # no version string found
            return False
        
        
    def get_version_string(self, aVersion):
        """Gets the full string specified in the gtkrc file for version. 
        If nothing is found null(empty string) is returned.
        """
        ver = self.__lookup_line(aVersion)
        return ver.strip("#")


    def get_property_value(self, aPropertyName):
        """ Gets the value of the specified property. 
        =================================================================================
        The property name and the given string should match. If the returned string 
        is empty no match is found.
        """
        if aPropertyName == '':
            return ""
        else:
            line = self.__lookup_line(aPropertyName)
            
            if line != '' and self.__strip(line).find("#") != 0: # comments are not valid properties
                
                list = line.split('=', 1)
                
                #check if there is comment at the back and remove it too
                if list[1].find('#') != -1:
                    list = list[1].split('#',1)
                    value = list[0]
                else:
                    value = list[1]
                    
                return self.__strip(value)
            else: #No match
                return ""
            
            
    def get_property_color_value(self, aPropertyName):
        """ Gets the hex color value of the specified property. 
        =================================================================================
        The property name and the given string should match. If the returned string 
        is empty no match is found.
        """
        if aPropertyName == '':
            return ""
        else:
            line = self.__lookup_line(aPropertyName)
            
            if line != '' and self.__strip(line).find("#") != 0: # comments are not valid properties
                
                list = line.split('=', 1)
                
                color = self.__strip(list[1])
                
                # If there is comment remove it
                if color.find('#') > 2:
                    list = color.split('#',2)
                    value = list[1]
                else:
                    value = color

                return self.__strip_quotes(value)
            else: #No match
                return ""
            
            
    def insert_text (self, aAfterLine, aText):
        """ Inserts the text after the specified line.
        =================================================================================
        The function returns true if the text is inseted else false. It iserts only 
        once and if you want to do it for seveal lines you'll have to call it several 
        times not just once.
        """
        if aAfterLine == None or aText == None:
            return False
        else:
            i = 0
            in_nwc_block = False #Wether the reading is in nwc block
            result = False
                
            for line in self.mFileContent:
                stline = self.__strip(line)
                #check for block tags
                if stline == self.mNWC_BStart:
                    in_nwc_block = True
                if stline == self.mNWC_BEnd:
                    in_nwc_block = False
                    
                if in_nwc_block == False:
                    i = i + 1
                    continue 
                    
                if stline.find("#") != 0 and (line.find(aAfterLine) != -1) and (in_nwc_block == True):
                    #insert the text
                    self.mFileContent.insert(i+1, aText)
                    return True
                
                i = i + 1
        
        return False
            

    def print_contents(self):
        """Prints the whole document that is loaded to the terminal"""
        print self.mFileContent


    def rm_spaces(self,aLine):
        """ Remove all spaces in the string specified.
        ================================================================================= 
        aLine = the line to strip of all spaces
        """
        return self.__strip_internal(aLine)


    def __strip_internal(self, line):
        """removes unwanetd tabs whitespaces and new lines"""
        line = line.replace(' ','')
        line = line.replace('\t','')
        line = line.replace('\n','')
        return line
    
    
    def __strip(self, line):
        """removes only spaces from both sides of the string"""
        line = line.strip()
        line = line.strip('\t')
        line = line.strip('\n')
        return line
    
    def __strip_quotes(self, line):
        """removes only spaces from both sides of the string"""
        line = line.strip('\"')
        line = line.strip('\'')
        return line


    def __lookup_line(self, aContainingText):
        if aContainingText == '' or aContainingText == None:
            return ''
        else:
            in_nwc_block = False #Wether the reading is in nwc block
            
            for line in self.mFileContent:
                stline = self.__strip(line)
                #check for block tags
                if stline == self.mNWC_BStart:
                    in_nwc_block = True
                if stline == self.mNWC_BEnd:
                    in_nwc_block = False
                    
                if in_nwc_block == False:
                    continue 
                    
                if (line.find(aContainingText) != -1) and (in_nwc_block == True):
                    #return the desired line
                    return line
                
                
        return ''
    
    
    def __lookup_line_noNWC(self, aContainingText):
        """ this method is not limited by the NWC tags"""
        if aContainingText == '' or aContainingText == None:
            return ''
        else:
            for line in self.mFileContent:
                if line.find(aContainingText) != -1:
                    #return the desired line
                    return line
        return ''
    
    
    def __remove_comments(self, line):
        if line != '':
            list = line.split('#', 1)
            if len(list) > 1:
                return list[0]
            else:
                return line
        else:
            return line


"""
if __name__ == "__main__":

    rc = GtkRcFile("/home/toni/.themes/New Wave/gtk-2.0/gtkrc")
    
    if rc.load_file():
        #rc.print_contents()
        
        #check the version of New Wave
        if not rc.theme_version("0.8.1"):
            print "Theme not compatiable with configurator."
        else:
            print "Theme compatiable with configurator."
             
         
            #modify properties
            if rc.modify_first_line("GtkScrollbar::    has-backward-stepper= 1", "\tGtkScrollbar   ::has-backward-stepper = 0\n"):
                print "Line modified"
            if rc.modify_first_line("GtkScrollbar::has-secondary-backward-stepper=0", "\tGtkScrollbar   ::has-secondary-backward-stepper = 1\n"):
                print "Line modified"  
            if rc.save_file():
                print "File saved"
          
            print "\n Done."
         
            print rc.get_property_value("base[SELECTED]")
            
    else:
        print "Could not find file"

"""    
