#!/usr/bin/env python

#
# ===== NW Configurator UI v.0.2 =====
#
# This is simple program that configures the
# "New Wave pixmap theme"
# in an easy way.
# 
# Anton Kerezov <ankere@gmail.com>
# License GPL v3.0

import sys
import os
import user
import pygtk
pygtk.require("2.0")
import gtk
import nw_core


class ThemePickerUI:
    
    #the default is empty path => the main dialog will quit on that
    ThemeDir = ""
    OverridePrefix = "^  " # MUST be a sign at the begining and spaces otherwise change on_btnEdit_clicked
    Dirs = []
    
     
    def on_dlgPicker_close(self, widget, data=None):
        ThemeDir = ""

        
    def on_btnHelp_clicked(self, widget, data=None):
        dlg = gtk.MessageDialog(parent=self.dialog, flags=gtk.DIALOG_MODAL, type=gtk.MESSAGE_INFO, buttons= gtk.BUTTONS_OK, message_format="Themes prefixed with '^' are with lower priority and point upwards to the theme that will be shown insted because it's located in your home folder. Thus if you remove the home folder theme the other will be used.")
        dlg.set_title("Prefix Help")            
        dlg.run()
        dlg.destroy()
        
        
    def on_btnEdit_clicked(self, widget, data=None):
        model = self.combo.get_model()
        active = self.combo.get_active()
        if active < 0:
            self.ThemeDir = ""
        self.ThemeDir =  model[active][0]
        
        # remove the priority prefix
        if self.ThemeDir.find(self.OverridePrefix) != -1:
            self.ThemeDir = self.ThemeDir.strip(self.OverridePrefix[0]) #rm the different sign
            self.ThemeDir = self.ThemeDir.strip()
            
            
    def FillCombo(self, dirs):
        HomeDirInstalled = False
        HomeDirInstalledDark = False
        HomeDirInstalledMinimal = False
        HomeDirInstalledMinimalDark = False
        HasPrefix = False
        
        # enable different colors
        #self.renderer.set_property("foreground_set" , True)
        #self.renderer.set_property("foreground", "#141414")
        
        for path in dirs:
            
            if path.find("/.themes/") != -1:
                # check for user intalled themes
                if not HomeDirInstalled and path.find("/New Wave/")!= -1:
                    HomeDirInstalled = True
                elif not HomeDirInstalledDark and path.find("/New Wave Dark")!= -1:
                    HomeDirInstalledDark = True
                elif not HomeDirInstalledMinimal and path.find("/New Wave Minimal/")!= -1:
                    HomeDirInstalledMinimal = True
                elif not HomeDirInstalledMinimalDark and path.find("/New Wave Dark Menus Minimal/")!= -1:
                    HomeDirInstalledMinimalDark = True
                    
                #self.renderer.set_property("foreground", "#A40000")
            elif path.find("/usr/share/themes/")!= -1:
                if HomeDirInstalled and (path.find("/New Wave/")!= -1 or path.find("/NewWave/")!= -1):
                    path = self.OverridePrefix + path
                    HasPrefix = True
                    #self.renderer.set_property("foreground", "#877969")
                elif HomeDirInstalledDark and (path.find("/New Wave Dark")!= -1 or path.find("/NewWaveDark")!= -1):
                    #self.renderer.set_property("foreground", "#877969")
                    path = self.OverridePrefix + path
                    HasPrefix = True
                elif HomeDirInstalledMinimal and (path.find("/New Wave Minimal/")!= -1 or path.find("/NewWaveMinimal/")!= -1):
                    #self.renderer.set_property("foreground", "#877969")
                    path = self.OverridePrefix + path
                    HasPrefix = True
                elif HomeDirInstalledMinimalDark and (path.find("/New Wave Dark Menus Minimal/")!= -1 or path.find("/NewWaveDarkMenusMinimal/")!= -1):
                   # self.renderer.set_property("foreground", "#877969")
                    path = self.OverridePrefix + path
                    HasPrefix = True
                
            self.combo.append_text(path)
            
        #hide the help about the prefixed themes if there are none of them
        if HasPrefix:
            self.btnHelp.show()
    
    
    def __init__(self, dirs):

        builder_pick = gtk.Builder()
        builder_pick.add_from_file(os.path.dirname(__file__) + "/nw_conf.glade") 

        self.dialog = builder_pick.get_object("dlgPicker")
        self.combo = builder_pick.get_object("cmbLocations")
        self.renderer = builder_pick.get_object("crText")
        self.btnHelp = builder_pick.get_object("btnHelp")
        
        # Make a backup if it is needed
        self.Dirs = dirs
        self.FillCombo(dirs)
            
        self.combo.set_active(0)
        builder_pick.connect_signals(self)
        
        
    def showdialog(self):
        self.dialog.run()
        self.dialog.destroy()
        
        return self.ThemeDir
        


class NewWaveConfiguratorUI:
    
    NoFile = False          # If there is no file specifide this is changed to True
    MajorVersion = "0.8"    # This is used to specify what theme ver. setting 
                            #   will be reverted to in the 'Revert All' dlg
    MinThemeVer = "0.8.1"   # The minimum version (incl) with wich the configurator will work
    MaxThemeVer = "0.8.3"   # The maximum version (incl) with wich the configurator will work
    rc = None               # The main class to handle theme files
    HasChanges = False      # Marks if there are changes to the UI
    HasSaves = False        # If the file has been saved at least once
    Reverting = False       # If the user has pressed the Rever buton or on file load
    IsDarkVariant = False   # If the theme loaded is with dark menus
    RestartDialog = True    # If the succesful save dialog shows eachtime you save [disabled]
    PanelTheme = "panel"    # This is a variable for the loaded and later chosen Panel theme
    PanelEntryTheme = ""    # This is the theme of the entries in panels that mathes the panel theme
    FirstLoad = False       # If the theme has been loaded at least once (a.k.a. first load occured)
     
    Debug = False           # Internal variable that enables more info to the terminal output.
                            #      Set to True to see them Errors are always printed.
    
    
    def on_frmMain_destroy(self, widget, data=None):
        if self.ask_save() == True:
            gtk.main_quit()
        
            
    def on_mnu_file_quit_activate(self, widget, data=None):
        if self.ask_save() == True:
            gtk.main_quit()
            
        
    def on_mnu_help_about_activate(self, widget, data=None):
        if self.Debug:
            print "About dialog"
            
        builder_a = gtk.Builder()
        builder_a.add_from_file(os.path.dirname(__file__) + "/nw_conf.glade") 

        self.aboutdialog = builder_a.get_object("dlgAbout")
        builder_a.connect_signals(self)
        
        self.aboutdialog.run()
        self.aboutdialog.destroy()
            
            
    def on_save_theme_file_activate(self, widget, data=None):
        if self.save_file() == True:
            #show this message only once
            #if self.RestartDialog == True:
                dlg = gtk.MessageDialog(parent=self.window, flags=gtk.DIALOG_MODAL, type=gtk.MESSAGE_INFO, buttons= gtk.BUTTONS_OK, message_format="Changes are saved to the theme.\nTo see them you must reset it form the Appearance dialog.")
                dlg.set_title("File Saved")            
                dlg.run()
                dlg.destroy()
                #self.RestartDialog = False
        else:
            self.HasChanges = False
            if self.Debug:
                print "Save failed in 'on_save_theme_file_activate'..."

    def on_revert_changes_activate(self, button, data=None):
        self.Reverting = True
        self.rc.restore_file_data()
        
        if self.HasSaves == False:
            self.HasChanges = False
        else: 
            self.HasChanges = True
            
        self.__update_ui()
        self.Reverting = False
        
        if self.Debug:
            print "Reverted to first loaded."
            
            
    def on_mnu_file_revert_to_defaults_activate(self, button, data=None):
        # Ask whether the user want's this to be reverted
        dlg = gtk.MessageDialog(parent=self.window, flags=gtk.DIALOG_MODAL, type=gtk.MESSAGE_QUESTION, buttons= gtk.BUTTONS_YES_NO, message_format= "Would you like to restore the theme to the\ndefault settings of the major version '" + self.MajorVersion +"'?")
        dlg.set_title("Restore Default Settings")
        response = dlg.run()
        dlg.destroy()
        if response == gtk.RESPONSE_YES:
            # set the default settings for a theme release e.g 0.8.1
            # These settngs should be changed accordlingly to theme changes in the gtkrc file
            
            # set the steppers of scrollbars
            self.StepBoth.set_active(True)
            # Taskbar opacity %
            self.taskO.set_value(60)
            self.deskO.set_value(47)
            # Deskop transparency and color of selection bix
            self.nautilusOC.set_alpha(60*257)
            self.nautilusOC.set_color(gtk.gdk.color_parse("#EF9D6E"))
            self.nautilusOC.emit("color-set")
            # Tooltips timeout (ms)
            self.tooltipspin.set_value(970)
            # Change the theme to a Default one
            self.PanelThemer.set_active(0) # The FIRST is awlays the default one
            # Make the check inactive as default
            # self.FixCheck.set_active(0) #not used anymore
        
            self.HasChanges = True
                
            if self.Debug:
                print "Reverted to default settings."
            
    
    def on_mnu_file_info_activate(self, button, data=None):
        ver = self.rc.get_version_string(self.MajorVersion)
        
        dlg = gtk.MessageDialog(parent=self.window, flags=gtk.DIALOG_MODAL, type=gtk.MESSAGE_INFO, buttons= gtk.BUTTONS_OK, message_format="Full file path:\n" +"'" + self.rc.get_filename()+"'" + "\n\n" + ver)
        dlg.set_title("File Info")
        dlg.run()
        dlg.destroy()


    def on_rbTopBottom_toggled(self, button, data=None):
        if not self.Reverting:
            if self.StepBoth.get_active(): #Both arrow activated
                if self.modify_scroll(1, 1, 0, 0):
                    self.HasChanges = True
                else:
                    print "Failed to change steppers"
                
        
    def on_rbBottom_toggled(self, button, data=None):
        if not self.Reverting:
            if self.StepBottom.get_active(): 
                if self.modify_scroll(0, 1, 1, 0):
                    self.HasChanges = True
                else:
                    print "Failed to change steppers"
        

    def on_rbTop_toggled(self, button, data=None):
        if not self.Reverting:
            if self.StepTop.get_active():
                if self.modify_scroll(1, 0, 0, 1):
                    self.HasChanges = True
                else:
                    print "Failed to change steppers"


    def on_rbNone_toggled(self, button, data=None):
        if not self.Reverting:
            if self.StepNone.get_active(): # No steppers
                if self.modify_scroll(0, 0, 0, 0):
                    self.HasChanges = True
                else:
                    print "Failed to change steppers"
        
    
    def modify_scroll(self, down, up, sdown, sup):
        """A complex method for changing scrollbars according to switchs
        """
        bStep = int(self.rc.get_property_value("::has-backward-stepper"))
        fStep = int(self.rc.get_property_value("::has-forward-stepper"))
        sbStep = int(self.rc.get_property_value("::has-secondary-backward-stepper"))
        sfStep = int(self.rc.get_property_value("::has-secondary-forward-stepper"))
        
        bStep_old = "GtkScrollbar::has-backward-stepper=" + str(bStep)
        bStep_new = "\tGtkScrollbar   ::has-backward-stepper = " + str(up)
        
        fStep_old = "GtkScrollbar::has-forward-stepper=" + str(fStep)
        fStep_new = "\tGtkScrollbar   ::has-forward-stepper = " + str(down)
        
        sbStep_old = "GtkScrollbar::has-secondary-backward-stepper=" + str(sbStep)
        sbStep_new = "\tGtkScrollbar   ::has-secondary-backward-stepper = " + str(sup)
        
        sfStep_old = "GtkScrollbar::has-secondary-forward-stepper=" + str(sfStep)
        sfStep_new = "\tGtkScrollbar   ::has-secondary-forward-stepper = " + str(sdown)
        
        Transaction = True
        
        if not self.rc.modify_line(bStep_old,bStep_new):
                Transaction = False
        if not self.rc.modify_line(fStep_old,fStep_new):
                Transaction = False
        if not self.rc.modify_line(sbStep_old,sbStep_new):
                Transaction = False
        if not self.rc.modify_line(sfStep_old,sfStep_new):
                Transaction = False
                    
        if Transaction:
            if self.Debug:
                print "Scrollbars modified."
            return True
        else:
            return False
            

    def on_adjTootltip_value_changed(self, spin, data=None):
        if not self.Reverting:
            old = "gtk-tooltip-timeout=" + self.rc.get_property_value("gtk-tooltip-timeout")
            new = "gtk-tooltip-timeout = " + str(self.tooltipspin.get_value_as_int())
        
            if self.rc.modify_line(old,new):
                self.HasChanges = True
            
            if self.Debug:
                print "Spin chnaged"
                print old
                print new + "\n"
        

    def on_adjTaskOverTransp_value_changed(self, pgrogress, data=None):
        if not self.Reverting:
            old = "WnckTasklist::fade-opacity=" + self.rc.get_property_value("::fade-opacity")
            new = "\tWnckTasklist   ::fade-opacity\t        = " + str(self.taskO.get_value()/100)
            
            if self.rc.modify_line(old,new):
                self.HasChanges = True
            
            if self.Debug:
                print "Taskbar transparency changed:"
                print old
                print new + "\n"
                
    
    def on_adjDeskTransp_value_changed(self, pgrogress, data=None):
        if not self.Reverting:
            old = "NautilusIconContainer::highlight_alpha=" + self.rc.get_property_value("NautilusIconContainer::highlight_alpha")
            new = "\tNautilusIconContainer::highlight_alpha= " + str(int(round(self.deskO.get_value()*2.55)))
            
            if self.rc.modify_line(old,new):
                self.HasChanges = True
            
            if self.Debug:
                print "Desktop transparency changed:"
                print old
                print new + "\n"
            
        
    def on_cbtnNautilusBox_color_set(self, pgrogress, data=None):
        if not self.Reverting:
            alpha = self.nautilusOC.get_alpha()
            colorstring = gtk.color_selection_palette_to_string([self.nautilusOC.get_color()])

            old_transp = "NautilusIconContainer::selection_box_alpha=" + self.rc.get_property_value("NautilusIconContainer::selection_box_alpha ")
            new_transp = "\tNautilusIconContainer::selection_box_alpha = " +str(alpha/257)
            
            old_color = "NautilusIconContainer::selection_box_color=\"" + self.rc.get_property_color_value("NautilusIconContainer::selection_box_color") + "\""
            new_color = "\tNautilusIconContainer::selection_box_color = \"" + colorstring + "\""
            
            Transaction = True
            
            if not self.rc.modify_line(old_transp,new_transp):
                Transaction = False
        
            if not self.rc.modify_color_line(old_color,new_color):
                Transaction = False
                # Revert what has been done beforehand
                self.rc.modify_line(new_transp,old_transp)

            # If the rangsaction is ok mark the changes 
            if Transaction:
                self.HasChanges = True
                
            if self.Debug:    
                if self.HasChanges: print "Desktop transparency & color changed"
                else: print "Desktop transparency & color change FAILED"
                print old_transp
                print new_transp 
                print old_color
                print new_color + "\n"


    def on_cmbPanelTheme_changed(self, combo, data=None):
        if not self.Reverting:
            model = self.PanelThemer.get_model()
            active = self.PanelThemer.get_active()
            if active < 0:
                self.PanelTheme = "panel"
            newTheme =  model[active][1]
            
            if self.Debug:
                print "Old Theme: " + self.PanelTheme

            # Change styles of panels and entries in them according to choosent text from the combo.
            if newTheme == " Default":
                if self.rc.change_style(self.PanelTheme, "panel") and self.rc.change_style(self.PanelEntryTheme, "newwave-panel-entry"):
                    # assign the new theme
                    self.PanelTheme = "panel"
                    self.PanelEntryTheme = "newwave-panel-entry"
                    self.HasChanges = True
            elif newTheme == " Light":
                if self.rc.change_style(self.PanelTheme, "panel-light") and self.rc.change_style(self.PanelEntryTheme, "newwave-entry"):
                    self.PanelTheme = "panel-light"
                    self.PanelEntryTheme = "newwave-entry"
                    self.HasChanges = True
            elif newTheme == " Noir":
                if self.rc.change_style(self.PanelTheme, "panel-black") and self.rc.change_style(self.PanelEntryTheme, "newwave-panel-entry-noir"):
                    self.PanelTheme = "panel-black"
                    self.PanelEntryTheme = "newwave-panel-entry-noir"
                    self.HasChanges = True
            elif newTheme >= " Flat":
                if self.rc.change_style(self.PanelTheme, "panel-nopixmap") and self.rc.change_style(self.PanelEntryTheme, "newwave-panel-entry-nopixmap"):
                    self.PanelTheme = "panel-nopixmap"
                    self.PanelEntryTheme = "newwave-panel-entry-nopixmap"
                    self.HasChanges = True
            elif newTheme == " Blue":
                if self.rc.change_style(self.PanelTheme, "panel-blue")and self.rc.change_style(self.PanelEntryTheme, "newwave-panel-entry-blue"):
                    self.PanelTheme = "panel-blue"
                    self.PanelEntryTheme = "newwave-panel-entry-blue"
                    self.HasChanges = True
            else: print "Undeclared theme selected"
            
            if self.Debug:
                print "Theme selected: " + self.PanelTheme
        
        
    def on_chkOOFix_toggled(self, check, data=None):
        if not self.Reverting:
           
            #I'm following these instructions to set custom theme for OO suite:
            # http://www.rebelzero.com/fixes/openofficeorg-dark-theme-workaround-with-ubuntu-804/8
            
            # Step -1- Rename the original so that  we could use our theme
            os.system("gksu mv /usr/lib/openoffice/program/soffice /usr/lib/openoffice/program/soffice1")
            # Step -2- Create new script file to call the old one
            try:
                oo = open("/usr/lib/openoffice/program/soffice", "w")
                # Step -3- Write some data to load custom theme
                # TODO -create the spec oo file
                soffice_text = "#!/bin/sh  \n env GTK2_RC_FILES=\""+ self.rc.get_filename()+ "-oo" + "\" /usr/lib/openoffice/program/soffice1 \"$@\""
                oo.writelines(soffice_text)
                if self.Debug:                 
                    print soffice_text 
                    
                oo.close()
            except:
                print "Could not create file: /usr/lib/openoffice/program/soffice"
                # TODO: Show err dlg and 
                # Resotre changes
                os.system("gksu mv /usr/lib/openoffice/program/soffice1 /usr/lib/openoffice/program/soffice")
                self.HasChanges = False
                 
                
            # Step -4- Make it executable    
            os.system("gksu chmod +x /usr/lib/openoffice/program/soffice")
            
            # Step -5a-  Rename the binary to be used by soffice1 but if 
            # there are links to it they will not be valid anymore. 
            #  -5b- Alternative solution that fixes this is:
            # find and comment the line: 'sd_binary='basename "$0"'".bin"' in soffice1 and 
            # replace it with: 'sd_binary="soffice.bin"'
            os.system("gksu mv /usr/lib/openoffice/program/soffice.bin /usr/lib/openoffice/program/soffice1.bin")
        
            self.HasChanges = True
            
            if self.Debug:    
                print "Applied custom themes to OO group of apps"
                
        """
        # Old fix for Firefox, Open office and VLC
        if not self.Reverting:
            Line = self.rc.find_line("widget_class \"*Fix*MenuBar*\"")
            
            if self.Debug:
                print "Old line: " + Line

            if self.FixCheck.get_active() == True:
                if self.rc.comment_line(Line, False):
                    self.HasChanges = True
            else:
                if self.rc.comment_line(Line, True):
                    self.HasChanges = True
     
            if self.Debug:
                Line = self.rc.find_line("widget_class \"*Fix*MenuBar*\"")
                print "New line: " + Line
        """  
        
        
    def __init__(self, path):
        if path == '':
            self.NoFile = True
        
        
        builder = gtk.Builder()
        builder.add_from_file(os.path.dirname(__file__) + "/nw_conf.glade") 
        self.window = builder.get_object("frmMain")
        
        #get the ref to the controls
        #tooltip spin
        self.tooltipspin = builder.get_object("spinTooltipTimeout")
        
        #range controls for opacity
        self.nautilusOC= builder.get_object("cbtnNautilusBox")
        self.NautilusBox = builder.get_object("vboxNautilus")
        
        # Desktop & taskbar opacity of selecte items
        self.deskO = builder.get_object("rngDeskTransp")
        self.taskO = builder.get_object("rngTaskTransp")
        
        # Option buttons
        self.StepBoth = builder.get_object("rbTopBottom")
        self.StepBottom = builder.get_object("rbBottom")
        self.StepTop = builder.get_object("rbTop")
        self.StepNone = builder.get_object("rbNone")
        
        #the FF fix objects
        self.FixBox = builder.get_object("vboxFix")
        self.FixCheck = builder.get_object("chkOOFix")
        
        # Panel themes combo
        self.PanelThemer = builder.get_object("cmbPanelTheme")
        self.PanelBox = builder.get_object("vboxPanel")
        
        
        builder.connect_signals(self)
        
        if path.find("Dark") != -1:
            self.IsDarkVariant = True
    
        self.rc = nw_core.GtkRcFile(path)
        if self.rc.load_file():
            #rc.print_contents()
            
            if not self.rc.theme_version_range(self.MinThemeVer, self.MaxThemeVer):
                print "Theme not compatible with configurator. Required theme version from: " + self.MinThemeVer + " to: " + self.MaxThemeVer + "\n\nPleae select another theme."
                errdlg = gtk.MessageDialog(parent=self.window, flags=gtk.DIALOG_MODAL, type=gtk.MESSAGE_ERROR, buttons= gtk.BUTTONS_OK, message_format="Theme not compatible with configurator.\nRequired theme version from: " + self.MinThemeVer + " to: " + self.MaxThemeVer + " .")
                errdlg.set_title("Load Error")
                errdlg.run()
                errdlg.destroy()
                self.NoFile = True
            else:
                
                #Do not show the Fix vbox because the issue is solved i OO 3.1.1
                #if not self.IsDarkVariant:
                #    self.FixBox.show()
                    
                if self.rc.theme_version("0.8.1"):
                    # CHECK: hide panel themeing if not 0.8.2+ in Ubuntu 9.10
                    self.PanelBox.hide()
                    
                self.__update_ui()
                self.FirstLoad = True


        else:
            print "Could not load file"
            self.NoFile = True
            
        


    def __update_ui(self):
        # This method inserts text and values if they are missing from the gtkrc file so 
        # if there is custom theme using the program you shout make sure it doers not conflict with
        # the specified insertion points and if they are in the NWC-START/END tags.
        
        # This is used in order for the UI not to recieve event for the updates
        self.Reverting = True
        
        HasInserts = False
        
        # Update the tooltip value
        val = self.rc.get_property_value("gtk-tooltip-timeout")
        if val == '' or val == None:
            val = "970"
            if self.rc.insert_text("gtk-enable-animations", "gtk-tooltip-timeout = "+val+"\n"):
                self.HasChanges = True
                HasInserts = True
        defSpin = float(val)
        self.tooltipspin.set_value(defSpin) 
   
        # Update the Nautilus color button values
        val2 = self.rc.get_property_value("NautilusIconContainer::selection_box_alpha")
        if val2 == '' or val2 == None:
            val2 = "60"
            if self.rc.insert_text("NautilusIconContainer::highlight_alpha", "\tNautilusIconContainer::selection_box_alpha = "+val2+"\n"):
                self.HasChanges = True
                HasInserts = True
        defDeskO = int(val2)*257 # the range is 0 - 65535.
        self.nautilusOC.set_alpha(defDeskO)
        
        color = self.rc.get_property_color_value("NautilusIconContainer::selection_box_color")
        if color == '' or color == None:
            color = "#675B54"
            if self.rc.insert_text("NautilusIconContainer::selection_box_alpha", "\tNautilusIconContainer::selection_box_color = \""+ color +"\"\n"):
                self.HasChanges = True
                HasInserts = True
        defDeskC = gtk.gdk.color_parse(color)
        self.nautilusOC.set_color(defDeskC)
        
        # Max here is 1.0 so we transform it to 100 to fit our scale
        val3 = self.rc.get_property_value("::fade-opacity")
        if val3 == '' or val3 == None:
            val3 = "0.6"
            if self.rc.insert_text("::fade-overlay-rect", "\tWnckTasklist    ::fade-opacity\t\t= "+val3+"\n"):
                self.HasChanges = True
                HasInserts = True
        defTaskO = 100 * float(val3) 
        self.taskO.set_value(defTaskO)
        
        # set the opacity of desktop items
        val4 = self.rc.get_property_value("NautilusIconContainer::highlight_alpha")
        if val4 == '' or val3 == None:
            val4 = "120"
            if self.rc.insert_text("::fade-opacity", "\tNautilusIconContainer::highlight_alpha= "+val4+"\n"):
                self.HasChanges = True
                HasInserts = True
        defDesktO = int(float(val4) / 2.55)
        self.deskO.set_value(defDesktO)
    
        # Set the option btns for scrollbar arrows and check the values beforehand
        val_missing = False # if one line does not have valuse stop loading others too
        bs = self.rc.get_property_value("::has-backward-stepper")
        if bs == '':
            bs = "1"
            val_missing = True
        bStep = int(bs)
        
        fs = self.rc.get_property_value("::has-forward-stepper")
        if fs == '' or val_missing:
            val_missing = True
            fs = "1"
        fStep = int(fs)
        
        sbs = self.rc.get_property_value("::has-secondary-backward-stepper")
        if sbs == "" or val_missing:
            val_missing = True
            sbs = "0"
        sbStep = int(sbs)
        
        sfs = self.rc.get_property_value("::has-secondary-forward-stepper")
        if sfs == '' or val_missing:
            sfs = '0'
        sfStep = int(sfs)
        
        # Update the option buttons
        if bStep == 1 and fStep == 1 and sbStep == 0 and sfStep == 0:
            self.StepBoth.set_active(True)
            self.StepBottom.set_active(False)
            self.StepTop.set_active(False)
            self.StepNone.set_active(False)
        elif bStep == 0 and fStep == 0 and sbStep == 0 and sfStep == 0:
            self.StepBoth.set_active(False)
            self.StepBottom.set_active(False)
            self.StepTop.set_active(False)
            self.StepNone.set_active(True)
        elif bStep == 1 and fStep == 0 and sbStep == 0 and sfStep == 1: 
            self.StepBoth.set_active(False)
            self.StepBottom.set_active(False)
            self.StepTop.set_active(True)
            self.StepNone.set_active(False)
        elif bStep == 0 and fStep == 1 and sbStep == 1 and sfStep == 0: 
            self.StepBoth.set_active(False)
            self.StepBottom.set_active(True)
            self.StepTop.set_active(False)
            self.StepNone.set_active(False)
        
        # Get the panel style name and assign it to the local var  
        # use widget "*PanelApplet*" as a reference point
        currentPanelTheme = self.rc.get_style_name("widget \"*PanelApplet*\"") 
        if currentPanelTheme != '': #theme found
            self.PanelTheme = currentPanelTheme
        else: #use default one
            self.PanelTheme = "panel"
            
        # Get the current entry theme (needed to match with panel)
        currentPanelEntryTheme = self.rc.get_style_name("widget_class \"*Panel*Entry*\"") 
        if currentPanelEntryTheme != '': #theme found
            self.PanelEntryTheme = currentPanelEntryTheme
        else: #use default one
            self.PanelEntryTheme = "newwave-panel-entry"
            
        if self.Debug:
            print self.PanelTheme
            print self.PanelEntryTheme
            
        # Change the combo value
        if self.PanelTheme == "panel":
            self.PanelThemer.set_active(0)
        elif self.PanelTheme == "panel-light":
            self.PanelThemer.set_active(1)   
        elif self.PanelTheme == "panel-black":
            self.PanelThemer.set_active(2)
        elif self.PanelTheme == "panel-nopixmap":
            self.PanelThemer.set_active(3)
        elif self.PanelTheme == "panel-blue":
            self.PanelThemer.set_active(4)
        
        # Show this only once at the begining of the load
        if HasInserts == True and self.FirstLoad == False:
            dlg = gtk.MessageDialog(parent=self.window, flags=gtk.DIALOG_MODAL, type=gtk.MESSAGE_INFO, buttons= gtk.BUTTONS_OK, message_format= "The loaded theme has been adapted to work with\nsome of the Configurator's new properties.\nYou will need to save it to keep the reformatting.")
            dlg.set_title("Theme Partially Adapted")
            dlg.run()
            dlg.destroy()
            
        self.Reverting = False
            

    def main(self):
        if self.NoFile:
            print "Error: No rc file specified or rc file not compatiable. Aborting ..."
            return 1

        self.window.show()
        gtk.main()
        
        
    def ask_save(self):
        if self.HasChanges:
            dlg = gtk.MessageDialog(parent=self.window, flags=gtk.DIALOG_MODAL, type=gtk.MESSAGE_QUESTION, buttons= gtk.BUTTONS_YES_NO, message_format= "There are changes made to the file. Would you like to save them?")
            dlg.set_title("Save Changes")
            response = dlg.run()
            dlg.destroy()
            if response == gtk.RESPONSE_YES:
                if not self.save_file():
                    errdlg = gtk.MessageDialog(parent=self.window, flags=gtk.DIALOG_MODAL, type=gtk.MESSAGE_ERROR, buttons= gtk.BUTTONS_OK, message_format= "Save failed. There have to be a problem with the file missing or renamed.\nFile:\""+self.rc.get_filename()+"\"")    
                    errdlg.set_title("Save Error")                    
                    errdlg.run()
                    errdlg.destroy()
            elif response == gtk.RESPONSE_NO:
                if self.Debug:
                    print "Skipped save"

        return True 
        
        
    def ask_save_stay(self):
        if self.HasChanges:
            dlg = gtk.MessageDialog(parent=self.window, flags=gtk.DIALOG_MODAL, type=gtk.MESSAGE_QUESTION, buttons= gtk.BUTTONS_OK_CANCEL, message_format= "There are changes made to the file. Would you like to save them and quit or stay?")
            dlg.set_title("Save Changes")
            response = dlg.run()
            dlg.destroy()
            if response == gtk.RESPONSE_OK:
                if not self.save_file():
                    errdlg = gtk.MessageDialog(parent=self.window, flags=gtk.DIALOG_MODAL, type=gtk.MESSAGE_ERROR, buttons= gtk.BUTTONS_OK, message_format= "Save failed. There have to be a problem with the file missing or renamed.\nFile:\""+self.rc.get_filename()+"\"")    
                    errdlg.set_title("Save Error") 
                    errdlg.run()
                    errdlg.destroy()
                    return False
                else:
                    return True
            elif response == gtk.RESPONSE_CANCEL:
                if self.Debug:
                    print "Skipped save"
                return False
        else:
            return True     
        
        
    def save_file(self):
        # No flag for changes is marked because the user have to be able 
        # to revert to the first loaded file.
        if self.HasChanges:
            if self.rc.save_file():
                print "File saved."
                self.HasChanges = False
                self.HasSaves = True
                return True
            else:
                print "Failed Save."
                errdlg = gtk.MessageDialog(parent=self.window, flags=gtk.DIALOG_MODAL, type=gtk.MESSAGE_ERROR, buttons= gtk.BUTTONS_OK, message_format= "Save failed. There have to be a problem with the file missing or renamed.\nFile: '"+self.rc.get_filename()+"'")    
                errdlg.set_title("Save Error") 
                errdlg.run()
                errdlg.destroy()
                return False
        else :
            dlg = gtk.MessageDialog(parent=self.window, flags=gtk.DIALOG_MODAL, type=gtk.MESSAGE_INFO, buttons= gtk.BUTTONS_OK, message_format= "File is already saved.")    
            dlg.set_title("Save ....") 
            dlg.run()
            dlg.destroy()


def LaunchPicker():
     #find installed themes
    checkList = []
    userHome = user.home
    
    # Themes in user's home
    checkList.append (userHome + "/.themes/New Wave/")
    # Try to find other themes of the same kind
    checkList.append ("/usr/share/themes/New Wave/")
    checkList.append ("/usr/share/themes/NewWave/")
    
    checkList.append (userHome + "/.themes/New Wave Dark Menus/")
    checkList.append ("/usr/share/themes/New Wave Dark Menus/")
    checkList.append ("/usr/share/themes/NewWaveDarkMenus/")
    
    # add support for future versions
    checkList.append (userHome + "/.themes/New Wave Minimal/")
    checkList.append ("/usr/share/themes/New Wave Minimal/")
    checkList.append ("/usr/share/themes/NewWaveMinimal/")
    
    checkList.append (userHome + "/.themes/New Wave Dark Menus Minimal/")
    checkList.append ("/usr/share/themes/New Wave Dark Menus Minimal")
    checkList.append ("/usr/share/themes/NewWaveDarkMenusMinimal/")
    
    dirList = []

    for path in checkList:
        if os.path.exists(path):
            dirList.append(path)
       
        
    if len(dirList) == 0:
        print "No themes are installed"
        errdlg = gtk.MessageDialog(parent=None, flags=gtk.DIALOG_MODAL, type=gtk.MESSAGE_ERROR, buttons= gtk.BUTTONS_OK, message_format="There are no New Wave themes installed.\nPlease install one or more and try again when ready.")
        errdlg.set_title("New Wave Configurator") 
        errdlg.run()
        errdlg.destroy()
        # if there are no themes return false
        return False
    
    elif len(dirList) > 1:
        #Let the user choose
        #dirList = ["/home/toni/.themes/New Wave", "/usr/share/themes/NewWave"]
        nwd = ThemePickerUI(dirList)
        selected_path = nwd.showdialog()
    elif len(dirList) == 1:
        selected_path = dirList[0]

    if selected_path !='':
       
        #Start the ui
        if selected_path.find("Dark") != -1:
            selected_path = selected_path + "gtk-2.0/default-gtkrc"
        else:
            selected_path = selected_path + "gtk-2.0/gtkrc"
        #print "THEME PATH: --->" + selected_path
        
        #Windows dev
        #selected_path = "C:\Documents and Settings\Trud\Desktop\New Wave\gtk-2.0\gtkrc"
        
        nwc = NewWaveConfiguratorUI(selected_path)
        nwc.main()
          
        return True



if __name__ == "__main__":
   
    LaunchPicker()
        


    
